/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;

public final class RetriableDownloadFlux
extends Flux<ByteBuffer> {
    private final Supplier<Flux<ByteBuffer>> downloadSupplier;
    private final BiFunction<Throwable, Long, Flux<ByteBuffer>> onDownloadErrorResume;
    private final int maxRetries;
    private final long position;
    private final int retryCount;

    public RetriableDownloadFlux(Supplier<Flux<ByteBuffer>> downloadSupplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> onDownloadErrorResume, int maxRetries, long position) {
        this(downloadSupplier, onDownloadErrorResume, maxRetries, position, 0);
    }

    private RetriableDownloadFlux(Supplier<Flux<ByteBuffer>> downloadSupplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> onDownloadErrorResume, int maxRetries, long position, int retryCount) {
        this.downloadSupplier = downloadSupplier;
        this.onDownloadErrorResume = onDownloadErrorResume;
        this.maxRetries = maxRetries;
        this.position = position;
        this.retryCount = retryCount;
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuffer> actual) {
        long[] currentPosition = new long[]{this.position};
        this.downloadSupplier.get().map(buffer -> {
            currentPosition[0] = currentPosition[0] + (long)buffer.remaining();
            return buffer;
        }).onErrorResume(throwable -> {
            int updatedRetryCount = this.retryCount + 1;
            if (updatedRetryCount > this.maxRetries) {
                return Flux.error(throwable);
            }
            return new RetriableDownloadFlux(() -> this.onDownloadErrorResume.apply((Throwable)throwable, currentPosition[0]), this.onDownloadErrorResume, this.maxRetries, currentPosition[0], updatedRetryCount);
        }).subscribe(actual);
    }
}

