/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.implementation.BinaryDataContent;
import com.azure.core.util.implementation.ByteArrayContent;
import com.azure.core.util.implementation.FileContent;
import com.azure.core.util.implementation.InputStreamContent;
import com.azure.core.util.implementation.SerializableContent;
import com.azure.core.util.implementation.StringContent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryData.class);
    static final JsonSerializer SERIALIZER = JsonSerializerProviders.createInstance(true);
    private final BinaryDataContent content;

    BinaryData(BinaryDataContent content) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
    }

    public static BinaryData fromStream(InputStream inputStream) {
        return new BinaryData(new InputStreamContent(inputStream));
    }

    public static Mono<BinaryData> fromStreamAsync(InputStream inputStream) {
        return Mono.fromCallable(() -> BinaryData.fromStream(inputStream));
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> data) {
        if (data == null) {
            return FluxUtil.monoError(LOGGER, new NullPointerException("'content' cannot be null."));
        }
        return FluxUtil.collectBytesInByteBufferStream(data).flatMap(bytes -> Mono.just(BinaryData.fromBytes(bytes)));
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> data, Long length) {
        if (data == null) {
            return FluxUtil.monoError(LOGGER, new NullPointerException("'content' cannot be null."));
        }
        if (length != null && length < 0L) {
            return FluxUtil.monoError(LOGGER, new IllegalArgumentException("'length' cannot be less than 0."));
        }
        if (length != null) {
            return FluxUtil.collectBytesInByteBufferStream(data, length.intValue()).flatMap(bytes -> Mono.just(BinaryData.fromBytes(bytes)));
        }
        return FluxUtil.collectBytesInByteBufferStream(data).flatMap(bytes -> Mono.just(BinaryData.fromBytes(bytes)));
    }

    public static BinaryData fromString(String data) {
        return new BinaryData(new StringContent(data));
    }

    public static BinaryData fromBytes(byte[] data) {
        return new BinaryData(new ByteArrayContent(data));
    }

    public static BinaryData fromObject(Object data) {
        return BinaryData.fromObject(data, SERIALIZER);
    }

    public static Mono<BinaryData> fromObjectAsync(Object data) {
        return BinaryData.fromObjectAsync(data, SERIALIZER);
    }

    public static BinaryData fromObject(Object data, ObjectSerializer serializer) {
        return new BinaryData(new SerializableContent(data, serializer));
    }

    public static Mono<BinaryData> fromObjectAsync(Object data, ObjectSerializer serializer) {
        return Mono.fromCallable(() -> BinaryData.fromObject(data, serializer));
    }

    public static BinaryData fromFile(Path file) {
        return BinaryData.fromFile(file, 8092);
    }

    public static BinaryData fromFile(Path file, int chunkSize) {
        return new BinaryData(new FileContent(file, chunkSize));
    }

    public byte[] toBytes() {
        return this.content.toBytes();
    }

    public String toString() {
        return this.content.toString();
    }

    public <T> T toObject(Class<T> clazz) {
        return this.toObject(TypeReference.createInstance(clazz), (ObjectSerializer)SERIALIZER);
    }

    public <T> T toObject(TypeReference<T> typeReference) {
        return this.toObject(typeReference, (ObjectSerializer)SERIALIZER);
    }

    public <T> T toObject(Class<T> clazz, ObjectSerializer serializer) {
        return this.toObject(TypeReference.createInstance(clazz), serializer);
    }

    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        Objects.requireNonNull(typeReference, "'typeReference' cannot be null.");
        Objects.requireNonNull(serializer, "'serializer' cannot be null.");
        return this.content.toObject(typeReference, serializer);
    }

    public <T> Mono<T> toObjectAsync(Class<T> clazz) {
        return this.toObjectAsync(TypeReference.createInstance(clazz), (ObjectSerializer)SERIALIZER);
    }

    public <T> Mono<T> toObjectAsync(TypeReference<T> typeReference) {
        return this.toObjectAsync(typeReference, (ObjectSerializer)SERIALIZER);
    }

    public <T> Mono<T> toObjectAsync(Class<T> clazz, ObjectSerializer serializer) {
        return this.toObjectAsync(TypeReference.createInstance(clazz), serializer);
    }

    public <T> Mono<T> toObjectAsync(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return Mono.fromCallable(() -> this.toObject(typeReference, serializer));
    }

    public InputStream toStream() {
        return this.content.toStream();
    }

    public ByteBuffer toByteBuffer() {
        return this.content.toByteBuffer();
    }

    public Flux<ByteBuffer> toFluxByteBuffer() {
        return this.content.toFluxByteBuffer();
    }

    public Long getLength() {
        return this.content.getLength();
    }
}

