/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import reactor.core.publisher.Mono;

public class ResponseValidationPolicyBuilder {
    private final Collection<BiConsumer<HttpResponse, ClientLogger>> assertions = new ArrayList<BiConsumer<HttpResponse, ClientLogger>>();

    public HttpPipelinePolicy build() {
        return new ResponseValidationPolicy(this.assertions);
    }

    public ResponseValidationPolicyBuilder addOptionalEcho(String headerName) {
        this.assertions.add((httpResponse, logger) -> {
            String requestHeaderValue = httpResponse.getRequest().getHeaders().getValue(headerName);
            String responseHeaderValue = httpResponse.getHeaderValue(headerName);
            if (responseHeaderValue != null && !responseHeaderValue.equals(requestHeaderValue)) {
                throw logger.logExceptionAsError(new RuntimeException(String.format("Unexpected header value. Expected response to echo `%s: %s`. Got value `%s`.", headerName, requestHeaderValue, responseHeaderValue)));
            }
        });
        return this;
    }

    public class ResponseValidationPolicy
    implements HttpPipelinePolicy {
        private final ClientLogger logger = new ClientLogger(ResponseValidationPolicy.class);
        private final Iterable<BiConsumer<HttpResponse, ClientLogger>> assertions;

        ResponseValidationPolicy(Iterable<BiConsumer<HttpResponse, ClientLogger>> assertions) {
            ArrayList<BiConsumer<HttpResponse, ClientLogger>> assertionsCopy = new ArrayList<BiConsumer<HttpResponse, ClientLogger>>();
            assertions.forEach(assertionsCopy::add);
            this.assertions = assertionsCopy;
        }

        @Override
        public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
            Mono<HttpResponse> httpResponse = next.process();
            for (BiConsumer<HttpResponse, ClientLogger> assertion : this.assertions) {
                httpResponse = httpResponse.map(response -> {
                    assertion.accept((HttpResponse)response, this.logger);
                    return response;
                });
            }
            return httpResponse;
        }
    }
}

