/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.QueueMessageEncoding;
import com.azure.storage.queue.QueueServiceAsyncClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.models.QueueItem;
import com.azure.storage.queue.models.QueueServiceProperties;
import com.azure.storage.queue.models.QueueServiceStatistics;
import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.time.Duration;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=QueueServiceClientBuilder.class)
public final class QueueServiceClient {
    private final QueueServiceAsyncClient client;

    QueueServiceClient(QueueServiceAsyncClient client) {
        this.client = client;
    }

    public String getQueueServiceUrl() {
        return this.client.getQueueServiceUrl();
    }

    public QueueServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public QueueMessageEncoding getMessageEncoding() {
        return this.client.getMessageEncoding();
    }

    public QueueClient getQueueClient(String queueName) {
        return new QueueClient(this.client.getQueueAsyncClient(queueName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueClient createQueue(String queueName) {
        return this.createQueueWithResponse(queueName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueClient> createQueueWithResponse(String queueName, Map<String, String> metadata, Duration timeout, Context context) {
        Mono<Response<QueueAsyncClient>> asyncResponse = this.client.createQueueWithResponse(queueName, metadata, context);
        Response<QueueAsyncClient> response = StorageImplUtils.blockWithOptionalTimeout(asyncResponse, timeout);
        return new SimpleResponse<QueueClient>(response, new QueueClient(response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteQueue(String queueName) {
        this.deleteQueueWithResponse(queueName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteQueueWithResponse(String queueName, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteQueueWithResponse(queueName, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueItem> listQueues() {
        return this.listQueues(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueItem> listQueues(QueuesSegmentOptions options, Duration timeout, Context context) {
        return this.listQueues(null, options, timeout, context);
    }

    PagedIterable<QueueItem> listQueues(String marker, QueuesSegmentOptions options, Duration timeout, Context context) {
        return new PagedIterable<QueueItem>(this.client.listQueuesWithOptionalTimeout(marker, options, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueServiceProperties getProperties() {
        return this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Mono<Response<QueueServiceProperties>> response = this.client.getPropertiesWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(QueueServiceProperties properties) {
        this.setPropertiesWithResponse(properties, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesWithResponse(QueueServiceProperties properties, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setPropertiesWithResponse(properties, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueServiceStatistics getStatistics() {
        return this.getStatisticsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueServiceStatistics> getStatisticsWithResponse(Duration timeout, Context context) {
        Mono<Response<QueueServiceStatistics>> response = this.client.getStatisticsWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.client.generateAccountSas(accountSasSignatureValues);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.client.generateAccountSas(accountSasSignatureValues, context);
    }
}

