/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessagesClearResponse;
import com.azure.storage.queue.implementation.models.MessagesDequeueResponse;
import com.azure.storage.queue.implementation.models.MessagesEnqueueResponse;
import com.azure.storage.queue.implementation.models.MessagesPeekResponse;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.models.QueueStorageException;
import reactor.core.publisher.Mono;

public final class MessagesImpl {
    private final MessagesService service;
    private final AzureQueueStorageImpl client;

    MessagesImpl(AzureQueueStorageImpl client) {
        this.service = RestProxy.create(MessagesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MessagesDequeueResponse> dequeueWithResponseAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.dequeue(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MessagesClearResponse> clearWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.clear(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MessagesEnqueueResponse> enqueueWithResponseAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.enqueue(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MessagesPeekResponse> peekWithResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        String peekonly = "true";
        String accept = "application/xml";
        return this.service.peek(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageMes")
    public static interface MessagesService {
        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessagesDequeueResponse> dequeue(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="numofmessages") Integer var3, @QueryParam(value="visibilitytimeout") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{queueName}/messages")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessagesClearResponse> clear(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/{queueName}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessagesEnqueueResponse> enqueue(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="visibilitytimeout") Integer var3, @QueryParam(value="messagettl") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @BodyParam(value="application/xml") QueueMessage var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessagesPeekResponse> peek(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="peekonly") String var3, @QueryParam(value="numofmessages") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

