/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.SignedIdentifiersWrapper;
import com.azure.storage.queue.implementation.models.QueuesCreateResponse;
import com.azure.storage.queue.implementation.models.QueuesDeleteResponse;
import com.azure.storage.queue.implementation.models.QueuesGetAccessPolicyResponse;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesResponse;
import com.azure.storage.queue.implementation.models.QueuesSetAccessPolicyResponse;
import com.azure.storage.queue.implementation.models.QueuesSetMetadataResponse;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.QueueStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class QueuesImpl {
    private final QueuesService service;
    private final AzureQueueStorageImpl client;

    QueuesImpl(AzureQueueStorageImpl client) {
        this.service = RestProxy.create(QueuesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueuesCreateResponse> createWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueuesDeleteResponse> deleteWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueuesGetPropertiesResponse> getPropertiesWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), queueName, "metadata", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueuesSetMetadataResponse> setMetadataWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), queueName, "metadata", timeout, metadata, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueuesGetAccessPolicyResponse> getAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueuesSetAccessPolicyResponse> setAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper queueAclConverted = new SignedIdentifiersWrapper(queueAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, queueAclConverted, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageQue")
    public static interface QueuesService {
        @Put(value="/{queueName}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesCreateResponse> create(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesDeleteResponse> delete(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesSetMetadataResponse> setMetadata(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesGetAccessPolicyResponse> getAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesSetAccessPolicyResponse> setAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") SignedIdentifiersWrapper var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

