/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.client;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import java.util.Locale;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class QueueClientFactory {
    private static final String SERVICE_URI_SEGMENT = ".queue.core.windows.net";

    private QueueClientFactory() {
    }

    public static QueueServiceClient createQueueServiceClient(QueueConfiguration configuration) {
        return new QueueServiceClientBuilder().endpoint(QueueClientFactory.buildAzureEndpointUri(configuration)).credential(QueueClientFactory.getCredentialForClient(configuration)).buildClient();
    }

    private static String buildAzureEndpointUri(QueueConfiguration configuration) {
        return String.format(Locale.ROOT, "https://%s.queue.core.windows.net", QueueClientFactory.getAccountName(configuration));
    }

    private static StorageSharedKeyCredential getCredentialForClient(QueueConfiguration configuration) {
        StorageSharedKeyCredential storageSharedKeyCredential = configuration.getCredentials();
        if (storageSharedKeyCredential != null) {
            return storageSharedKeyCredential;
        }
        return new StorageSharedKeyCredential(configuration.getAccountName(), configuration.getAccessKey());
    }

    private static String getAccountName(QueueConfiguration configuration) {
        return !ObjectHelper.isEmpty(configuration.getCredentials()) ? configuration.getCredentials().getAccountName() : configuration.getAccountName();
    }
}

