/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.logging.ByteBufFormat;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.Objects;
import reactor.netty.ChannelOperationsId;
import reactor.netty.Connection;
import reactor.netty.transport.logging.AdvancedByteBufFormat;

final class ReactorNettyLoggingHandler
extends LoggingHandler {
    private final AdvancedByteBufFormat byteBufFormat;
    private final Charset charset;
    static final int ORIGINAL_CHANNEL_ID_PREFIX_LENGTH = "[id: 0x".length();
    static final String CHANNEL_ID_PREFIX = "[id:";
    static final char CHANNEL_ID_SUFFIX = ']';

    ReactorNettyLoggingHandler(String name, LogLevel level, AdvancedByteBufFormat byteBufFormat) {
        super(name, level, byteBufFormat == AdvancedByteBufFormat.SIMPLE ? ByteBufFormat.SIMPLE : ByteBufFormat.HEX_DUMP);
        this.charset = null;
        this.byteBufFormat = byteBufFormat;
    }

    ReactorNettyLoggingHandler(String name, LogLevel level, Charset charset) {
        super(name, level);
        this.byteBufFormat = AdvancedByteBufFormat.TEXTUAL;
        this.charset = Objects.requireNonNull(charset, "charset");
    }

    @Override
    public ByteBufFormat byteBufFormat() {
        if (this.byteBufFormat == AdvancedByteBufFormat.SIMPLE) {
            return ByteBufFormat.SIMPLE;
        }
        if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
            return ByteBufFormat.HEX_DUMP;
        }
        throw new UnsupportedOperationException("ReactorNettyLoggingHandler isn't using the classic ByteBufFormat.");
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName) {
        String chStr = this.channelString(ctx.channel());
        return new StringBuilder(chStr.length() + 1 + eventName.length()).append(chStr).append(' ').append(eventName).toString();
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
        if (arg instanceof ByteBuf) {
            return this.formatByteBuf(ctx, eventName, (ByteBuf)arg);
        }
        if (arg instanceof ByteBufHolder) {
            return this.formatByteBufHolder(ctx, eventName, (ByteBufHolder)arg);
        }
        return this.formatSimple(ctx, eventName, arg);
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName, Object firstArg, Object secondArg) {
        if (secondArg == null) {
            return this.formatSimple(ctx, eventName, firstArg);
        }
        String chStr = this.channelString(ctx.channel());
        String arg1Str = String.valueOf(firstArg);
        String arg2Str = secondArg.toString();
        return new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + arg1Str.length() + 2 + arg2Str.length()).append(chStr).append(' ').append(eventName).append(": ").append(arg1Str).append(", ").append(arg2Str).toString();
    }

    private String channelString(Channel channel) {
        Connection connection = Connection.from(channel);
        if (connection instanceof ChannelOperationsId) {
            String channelStr = ((ChannelOperationsId)((Object)connection)).asLongText();
            return new StringBuilder(4 + channelStr.length() + 1).append(CHANNEL_ID_PREFIX).append(channelStr).append(']').toString();
        }
        String channelStr = channel.toString().substring(ORIGINAL_CHANNEL_ID_PREFIX_LENGTH);
        return new StringBuilder(4 + channelStr.length()).append(CHANNEL_ID_PREFIX).append(channelStr).toString();
    }

    private String formatByteBuf(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        String chStr = this.channelString(ctx.channel());
        int length = msg.readableBytes();
        if (length == 0) {
            return new StringBuilder(chStr.length() + 1 + eventName.length() + 4).append(chStr).append(' ').append(eventName).append(": 0B").toString();
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + 10 + 1;
        String message = "";
        if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
            int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
            int hexDumpLength = 2 + rows * 80;
            outputLength += hexDumpLength;
        } else if (this.byteBufFormat == AdvancedByteBufFormat.TEXTUAL) {
            message = msg.toString(this.charset);
            outputLength += message.length() + 1;
        }
        StringBuilder buf = new StringBuilder(outputLength).append(chStr).append(' ').append(eventName).append(": ").append(length).append('B');
        if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
            buf.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump(buf, msg);
        } else if (this.byteBufFormat == AdvancedByteBufFormat.TEXTUAL) {
            buf.append(' ').append(message);
        }
        return buf.toString();
    }

    private String formatByteBufHolder(ChannelHandlerContext ctx, String eventName, ByteBufHolder msg) {
        StringBuilder buf;
        String chStr = this.channelString(ctx.channel());
        String msgStr = msg.toString();
        ByteBuf content = msg.content();
        int length = content.readableBytes();
        if (length == 0) {
            return new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 4).append(chStr).append(' ').append(eventName).append(", ").append(msgStr).append(", 0B").toString();
        }
        if (this.byteBufFormat != AdvancedByteBufFormat.TEXTUAL) {
            int outputLength = chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 2 + 10 + 1;
            if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
                int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
                int hexDumpLength = 2 + rows * 80;
                outputLength += hexDumpLength;
            }
            buf = new StringBuilder(outputLength).append(chStr).append(' ').append(eventName).append(": ").append(msgStr).append(", ").append(length).append('B');
            if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
                buf.append(StringUtil.NEWLINE);
                ByteBufUtil.appendPrettyHexDump(buf, content);
            }
        } else {
            String message = content.toString(this.charset);
            int outputLength = chStr.length() + 1 + eventName.length() + 2 + 10 + 2 + message.length();
            buf = new StringBuilder(outputLength).append(chStr).append(' ').append(eventName).append(": ").append(length).append("B ").append(message);
        }
        return buf.toString();
    }

    private String formatSimple(ChannelHandlerContext ctx, String eventName, Object msg) {
        String chStr = this.channelString(ctx.channel());
        String msgStr = String.valueOf(msg);
        return new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + msgStr.length()).append(chStr).append(' ').append(eventName).append(": ").append(msgStr).toString();
    }
}

