/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import reactor.core.publisher.Mono;

public class ScrubEtagPolicy
implements HttpPipelinePolicy {
    private static final String ETAG = "eTag";

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.process().flatMap(response -> Mono.just(this.scrubETagHeader((HttpResponse)response)));
    }

    private HttpResponse scrubETagHeader(HttpResponse unprocessedResponse) {
        HttpHeader eTagHeader = unprocessedResponse.getHeaders().get(ETAG);
        if (eTagHeader == null) {
            return unprocessedResponse;
        }
        String etag = eTagHeader.getValue();
        boolean startsWithQuote = etag.startsWith("\"");
        boolean endsWithQuote = etag.endsWith("\"");
        if (startsWithQuote && endsWithQuote) {
            unprocessedResponse.getHeaders().set(eTagHeader.getName(), etag.substring(1, etag.length() - 1));
        } else if (startsWithQuote) {
            unprocessedResponse.getHeaders().set(eTagHeader.getName(), etag.substring(1));
        } else if (endsWithQuote) {
            unprocessedResponse.getHeaders().set(eTagHeader.getName(), etag.substring(0, etag.length() - 1));
        }
        return unprocessedResponse;
    }
}

