/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueClientBuilder;
import com.azure.storage.queue.QueueMessageEncoding;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.models.PeekedMessageItem;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueueProperties;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.SendMessageResult;
import com.azure.storage.queue.models.UpdateMessageResult;
import com.azure.storage.queue.sas.QueueServiceSasSignatureValues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=QueueClientBuilder.class)
public final class QueueClient {
    private final QueueAsyncClient client;

    QueueClient(QueueAsyncClient client) {
        this.client = client;
    }

    public String getQueueUrl() {
        return this.client.getQueueUrl();
    }

    public QueueServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public QueueMessageEncoding getMessageEncoding() {
        return this.client.getMessageEncoding();
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create() {
        this.createWithResponse(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.createWithResponse(metadata, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean createIfNotExists() {
        return this.createIfNotExistsWithResponse(null, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> createIfNotExistsWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.createIfNotExistsWithResponse(metadata, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.client.deleteIfExistsWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties getProperties() {
        return this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Mono<Response<QueueProperties>> response = this.client.getPropertiesWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setMetadataWithResponse(metadata, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueSignedIdentifier> getAccessPolicy() {
        return new PagedIterable<QueueSignedIdentifier>(this.client.getAccessPolicy());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(List<QueueSignedIdentifier> permissions) {
        this.setAccessPolicyWithResponse(permissions, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPolicyWithResponse(List<QueueSignedIdentifier> permissions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setAccessPolicyWithResponse(permissions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void clearMessages() {
        this.clearMessagesWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> clearMessagesWithResponse(Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.clearMessagesWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendMessageResult sendMessage(String messageText) {
        return this.sendMessageWithResponse(messageText, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendMessageResult sendMessage(BinaryData message) {
        return this.sendMessageWithResponse(message, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendMessageResult> sendMessageWithResponse(String messageText, Duration visibilityTimeout, Duration timeToLive, Duration timeout, Context context) {
        Mono<Response<SendMessageResult>> response = this.client.sendMessageWithResponse(BinaryData.fromString(messageText), visibilityTimeout, timeToLive, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendMessageResult> sendMessageWithResponse(BinaryData message, Duration visibilityTimeout, Duration timeToLive, Duration timeout, Context context) {
        Mono<Response<SendMessageResult>> response = this.client.sendMessageWithResponse(message, visibilityTimeout, timeToLive, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueMessageItem receiveMessage() {
        return this.client.receiveMessage().block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueMessageItem> receiveMessages(Integer maxMessages) {
        return this.receiveMessages(maxMessages, Duration.ofSeconds(30L), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueMessageItem> receiveMessages(Integer maxMessages, Duration visibilityTimeout, Duration timeout, Context context) {
        return new PagedIterable<QueueMessageItem>(this.client.receiveMessagesWithOptionalTimeout(maxMessages, visibilityTimeout, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PeekedMessageItem peekMessage() {
        return this.client.peekMessage().block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PeekedMessageItem> peekMessages(Integer maxMessages, Duration timeout, Context context) {
        return new PagedIterable<PeekedMessageItem>(this.client.peekMessagesWithOptionalTimeout(maxMessages, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UpdateMessageResult updateMessage(String messageId, String popReceipt, String messageText, Duration visibilityTimeout) {
        return this.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UpdateMessageResult> updateMessageWithResponse(String messageId, String popReceipt, String messageText, Duration visibilityTimeout, Duration timeout, Context context) {
        Mono<Response<UpdateMessageResult>> response = this.client.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteMessage(String messageId, String popReceipt) {
        this.deleteMessageWithResponse(messageId, popReceipt, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteMessageWithResponse(String messageId, String popReceipt, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteMessageWithResponse(messageId, popReceipt, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    public String getQueueName() {
        return this.client.getQueueName();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues) {
        return this.client.generateSas(queueServiceSasSignatureValues);
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues, Context context) {
        return this.client.generateSas(queueServiceSasSignatureValues, context);
    }
}

