/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessagesClearHeaders;
import com.azure.storage.queue.implementation.models.MessagesDequeueHeaders;
import com.azure.storage.queue.implementation.models.MessagesEnqueueHeaders;
import com.azure.storage.queue.implementation.models.MessagesPeekHeaders;
import com.azure.storage.queue.implementation.models.PeekedMessageItemInternal;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.implementation.models.QueueMessageItemInternal;
import com.azure.storage.queue.models.QueueStorageException;
import com.azure.storage.queue.models.SendMessageResult;
import java.util.List;
import reactor.core.publisher.Mono;

public final class MessagesImpl {
    private final MessagesService service;
    private final AzureQueueStorageImpl client;

    MessagesImpl(AzureQueueStorageImpl client) {
        this.service = RestProxy.create(MessagesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesDequeueHeaders, List<QueueMessageItemInternal>>> dequeueWithResponseAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.dequeue(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesDequeueHeaders, List<QueueMessageItemInternal>>> dequeueWithResponseAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.dequeue(this.client.getUrl(), queueName, numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<QueueMessageItemInternal>> dequeueAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId) {
        return this.dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout, requestId).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<QueueMessageItemInternal>> dequeueAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        return this.dequeueWithResponseAsync(queueName, numberOfMessages, visibilitytimeout, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesClearHeaders, Void>> clearWithResponseAsync(String queueName, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.clear(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesClearHeaders, Void>> clearWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.clear(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> clearAsync(String queueName, Integer timeout, String requestId) {
        return this.clearWithResponseAsync(queueName, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> clearAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.clearWithResponseAsync(queueName, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesEnqueueHeaders, List<SendMessageResult>>> enqueueWithResponseAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.enqueue(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesEnqueueHeaders, List<SendMessageResult>>> enqueueWithResponseAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.enqueue(this.client.getUrl(), queueName, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, queueMessage, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<SendMessageResult>> enqueueAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId) {
        return this.enqueueWithResponseAsync(queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout, requestId).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<SendMessageResult>> enqueueAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        return this.enqueueWithResponseAsync(queueName, queueMessage, visibilitytimeout, messageTimeToLive, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesPeekHeaders, List<PeekedMessageItemInternal>>> peekWithResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        String peekonly = "true";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.peek(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<MessagesPeekHeaders, List<PeekedMessageItemInternal>>> peekWithResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        String peekonly = "true";
        String accept = "application/xml";
        return this.service.peek(this.client.getUrl(), queueName, "true", numberOfMessages, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<PeekedMessageItemInternal>> peekAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId) {
        return this.peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<PeekedMessageItemInternal>> peekAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        return this.peekWithResponseAsync(queueName, numberOfMessages, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((List)res.getValue()));
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageMes")
    public static interface MessagesService {
        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessagesDequeueHeaders, List<QueueMessageItemInternal>>> dequeue(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="numofmessages") Integer var3, @QueryParam(value="visibilitytimeout") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{queueName}/messages")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessagesClearHeaders, Void>> clear(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/{queueName}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessagesEnqueueHeaders, List<SendMessageResult>>> enqueue(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="visibilitytimeout") Integer var3, @QueryParam(value="messagettl") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @BodyParam(value="application/xml") QueueMessage var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<MessagesPeekHeaders, List<PeekedMessageItemInternal>>> peek(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="peekonly") String var3, @QueryParam(value="numofmessages") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

