/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class MessageIdsUpdateHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-time-next-visible")
    private DateTimeRfc1123 xMsTimeNextVisible;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-popreceipt")
    private String xMsPopreceipt;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;

    public MessageIdsUpdateHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        String xMsTimeNextVisible = rawHeaders.getValue("x-ms-time-next-visible");
        if (xMsTimeNextVisible != null) {
            this.xMsTimeNextVisible = new DateTimeRfc1123(xMsTimeNextVisible);
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.xMsPopreceipt = rawHeaders.getValue("x-ms-popreceipt");
        String date = rawHeaders.getValue("Date");
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public MessageIdsUpdateHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public OffsetDateTime getXMsTimeNextVisible() {
        if (this.xMsTimeNextVisible == null) {
            return null;
        }
        return this.xMsTimeNextVisible.getDateTime();
    }

    public MessageIdsUpdateHeaders setXMsTimeNextVisible(OffsetDateTime xMsTimeNextVisible) {
        this.xMsTimeNextVisible = xMsTimeNextVisible == null ? null : new DateTimeRfc1123(xMsTimeNextVisible);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public MessageIdsUpdateHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsPopreceipt() {
        return this.xMsPopreceipt;
    }

    public MessageIdsUpdateHeaders setXMsPopreceipt(String xMsPopreceipt) {
        this.xMsPopreceipt = xMsPopreceipt;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public MessageIdsUpdateHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

