/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;
import org.apache.camel.util.ObjectHelper;

public class QueueConfigurationOptionsProxy {
    private final QueueConfiguration configuration;

    public QueueConfigurationOptionsProxy(QueueConfiguration configuration) {
        this.configuration = configuration;
    }

    public Duration getTimeout(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getTimeoutFromHeaders, this.configuration::getTimeout, exchange);
    }

    public Duration getVisibilityTimeout(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getVisibilityTimeout, this.configuration::getVisibilityTimeout, exchange);
    }

    public Duration getTimeToLive(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getTimeToLiveFromHeaders, this.configuration::getTimeToLive, exchange);
    }

    public Integer getMaxMessages(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getMaxMessagesFromHeaders, this.configuration::getMaxMessages, exchange);
    }

    public String getQueueName(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getQueueNameFromHeaders, this.configuration::getQueueName, exchange);
    }

    public Map<String, String> getMetadata(Exchange exchange) {
        return QueueExchangeHeaders.getMetadataFromHeaders(exchange);
    }

    public String getMessageId(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getMessageIdFromHeaders, this.configuration::getMessageId, exchange);
    }

    public String getPopReceipt(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getPopReceiptFromHeaders, this.configuration::getPopReceipt, exchange);
    }

    public QueuesSegmentOptions getQueuesSegmentOptions(Exchange exchange) {
        return QueueExchangeHeaders.getQueuesSegmentOptionsFromHeaders(exchange);
    }

    public boolean isCreateQueue(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getCreateQueueFlagFromHeaders, this.configuration::isCreateQueue, exchange);
    }

    public QueueOperationDefinition getQueueOperation(Exchange exchange) {
        return this.getOption(QueueExchangeHeaders::getQueueOperationsDefinitionFromHeaders, this.configuration::getOperation, exchange);
    }

    public QueueConfiguration getConfiguration() {
        return this.configuration;
    }

    private <R> R getOption(Function<Exchange, R> exchangeFn, Supplier<R> fallbackFn, Exchange exchange) {
        return ObjectHelper.isEmpty(exchange) || ObjectHelper.isEmpty(exchangeFn.apply(exchange)) ? fallbackFn.get() : exchangeFn.apply(exchange);
    }
}

