/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.operations;

import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.time.Duration;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.queue.client.QueueServiceClientWrapper;
import org.apache.camel.component.azure.storage.queue.operations.QueueOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class QueueServiceOperations {
    private final QueueConfigurationOptionsProxy configurationOptionsProxy;
    private final QueueServiceClientWrapper client;

    public QueueServiceOperations(QueueConfiguration configuration, QueueServiceClientWrapper client) {
        ObjectHelper.notNull(client, "client can not be null.");
        this.client = client;
        this.configurationOptionsProxy = new QueueConfigurationOptionsProxy(configuration);
    }

    public QueueOperationResponse listQueues(Exchange exchange) {
        if (exchange == null) {
            return QueueOperationResponse.create(this.client.listQueues(null, null));
        }
        QueuesSegmentOptions segmentOptions = this.configurationOptionsProxy.getQueuesSegmentOptions(exchange);
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        return QueueOperationResponse.create(this.client.listQueues(segmentOptions, timeout));
    }
}

