/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.support.LRUCacheFactory;

public class DefaultEndpointUtilizationStatistics
implements EndpointUtilizationStatistics {
    private final int maxCapacity;
    private final Map<String, Long> map;

    public DefaultEndpointUtilizationStatistics(int maxCapacity) {
        this.map = LRUCacheFactory.newLRUCache(16, maxCapacity, false);
        this.maxCapacity = maxCapacity;
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public synchronized void onHit(String uri) {
        this.map.compute(uri, (key, current) -> {
            if (current == null) {
                return 1L;
            }
            current = current + 1L;
            return current;
        });
    }

    @Override
    public void remove(String uri) {
        this.map.remove(uri);
    }

    @Override
    public Map<String, Long> getStatistics() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

