/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class EntityManagers {
    private EntityManagers() {
    }

    public static EntityManager resolveEntityManager(EntityManagerFactory entityManagerFactory) {
        EntityManagerHolder entityManagerHolder = (EntityManagerHolder)((Object)TransactionSynchronizationManager.getResource((Object)entityManagerFactory));
        if (entityManagerHolder != null) {
            return entityManagerHolder.getEntityManager();
        }
        return entityManagerFactory.createEntityManager();
    }

    public static void closeNonTransactionalEntityManager(EntityManager entityManager) {
        if (entityManager == null) {
            return;
        }
        boolean isTransactional = TransactionSynchronizationManager.hasResource((Object)entityManager.getEntityManagerFactory());
        if (isTransactional) {
            entityManager.close();
        }
    }
}

