/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.barcode.BarcodeImageType;
import org.apache.camel.dataformat.barcode.BarcodeParameters;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final Logger LOG = LoggerFactory.getLogger(BarcodeDataFormat.class);
    private BarcodeParameters params;
    private final Map<EncodeHintType, Object> writerHintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
    private final Map<DecodeHintType, Object> readerHintMap = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);

    public BarcodeDataFormat() {
        this.setDefaultParameters();
        this.optimizeHints();
    }

    public BarcodeDataFormat(BarcodeFormat format) {
        this.setDefaultParameters();
        this.params.setFormat(format);
        this.optimizeHints();
    }

    public BarcodeDataFormat(int width, int height) {
        this.setDefaultParameters();
        this.params.setHeight(height);
        this.params.setWidth(width);
        this.optimizeHints();
    }

    public BarcodeDataFormat(BarcodeImageType type) {
        this.setDefaultParameters();
        this.params.setType(type);
        this.optimizeHints();
    }

    public BarcodeDataFormat(int width, int height, BarcodeImageType type, BarcodeFormat format) {
        this.setDefaultParameters();
        this.params.setHeight(height);
        this.params.setWidth(width);
        this.params.setType(type);
        this.params.setFormat(format);
        this.optimizeHints();
    }

    public String getDataFormatName() {
        return "barcode";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.printImage(exchange, graph, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.readImage(exchange, stream);
    }

    protected final void setDefaultParameters() {
        this.params = new BarcodeParameters();
    }

    protected final void optimizeHints() {
        this.writerHintMap.clear();
        this.readerHintMap.clear();
        String format = this.params.getFormat().toString();
        if (format.equals(BarcodeFormat.QR_CODE.toString())) {
            this.writerHintMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H);
        }
        if (format.equals(BarcodeFormat.DATA_MATRIX.toString())) {
            this.writerHintMap.put(EncodeHintType.DATA_MATRIX_SHAPE, (Object)SymbolShapeHint.FORCE_SQUARE);
        }
        this.readerHintMap.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
    }

    private void printImage(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        String payload = (String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, (Object)graph);
        MultiFormatWriter writer = new MultiFormatWriter();
        String type = this.params.getType().toString();
        BitMatrix matrix = writer.encode(payload, this.params.getFormat(), this.params.getWidth(), this.params.getHeight(), this.writerHintMap);
        MatrixToImageWriter.writeToStream(matrix, type, stream);
    }

    private String readImage(Exchange exchange, InputStream stream) throws Exception {
        MultiFormatReader reader = new MultiFormatReader();
        BufferedInputStream in = (BufferedInputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(BufferedInputStream.class, (Object)stream);
        BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(new BufferedImageLuminanceSource(ImageIO.read(in))));
        Result result = reader.decode(bitmap, this.readerHintMap);
        exchange.getOut().setHeader("BarcodeFormat", (Object)result.getBarcodeFormat());
        return result.getText();
    }

    public final void addToHintMap(EncodeHintType hintType, Object value) {
        this.writerHintMap.put(hintType, value);
        LOG.info(String.format("Added '%s' with value '%s' to writer hint map.", hintType.toString(), value.toString()));
    }

    public final void addToHintMap(DecodeHintType hintType, Object value) {
        this.readerHintMap.put(hintType, value);
    }

    public final void removeFromHintMap(EncodeHintType hintType) {
        if (this.writerHintMap.containsKey((Object)hintType)) {
            this.writerHintMap.remove((Object)hintType);
            LOG.info(String.format("Removed '%s' from writer hint map.", hintType.toString()));
        } else {
            LOG.warn(String.format("Could not find encode hint type '%s' in writer hint map.", hintType.toString()));
        }
    }

    public final void removeFromHintMap(DecodeHintType hintType) {
        if (this.readerHintMap.containsKey((Object)hintType)) {
            this.readerHintMap.remove((Object)hintType);
            LOG.info(String.format("Removed '%s' from reader hint map.", hintType.toString()));
        } else {
            LOG.warn(String.format("Could not find decode hint type '%s' in reader hint map.", hintType.toString()));
        }
    }

    public final BarcodeParameters getParams() {
        return this.params;
    }

    public final Map<EncodeHintType, Object> getWriterHintMap() {
        return this.writerHintMap;
    }

    public final Map<DecodeHintType, Object> getReaderHintMap() {
        return this.readerHintMap;
    }

    public void setBarcodeImageType(BarcodeImageType type) {
        this.params.setType(type);
        this.optimizeHints();
    }

    public void setBarcodeFormat(BarcodeFormat format) {
        this.params.setFormat(format);
        this.optimizeHints();
    }

    public void setWidth(Integer width) {
        this.params.setWidth(width);
    }

    public void setHeight(Integer height) {
        this.params.setHeight(height);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

