/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.IsSingleton;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Language;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.TimeUtils;

public abstract class LanguageSupport
implements Language,
IsSingleton,
CamelContextAware {
    public static final String RESOURCE = "resource:";
    private static final String[] SIMPLE_FUNCTION_START = new String[]{"${", "$simple{"};
    private CamelContext camelContext;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    protected String loadResource(String expression) throws ExpressionIllegalSyntaxException {
        if (this.camelContext != null && this.isStaticResource(expression)) {
            String uri = expression.substring(RESOURCE.length());
            InputStream is = null;
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.camelContext, uri);
                expression = this.camelContext.getTypeConverter().mandatoryConvertTo(String.class, is);
            }
            catch (Exception e) {
                try {
                    throw new ExpressionIllegalSyntaxException(expression, e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
        }
        return expression;
    }

    protected boolean isStaticResource(String expression) {
        return expression.startsWith(RESOURCE) && !LanguageSupport.hasSimpleFunction(expression);
    }

    protected boolean isDynamicResource(String expression) {
        return expression.startsWith(RESOURCE) && LanguageSupport.hasSimpleFunction(expression);
    }

    public static boolean hasSimpleFunction(String expression) {
        if (expression != null) {
            return expression.contains(SIMPLE_FUNCTION_START[0]) || expression.contains(SIMPLE_FUNCTION_START[1]);
        }
        return false;
    }

    protected <T> T property(Class<T> type, Object[] properties, int index, Object defaultValue) {
        String text;
        List<Object> value;
        List<Object> list = value = properties != null ? properties[index] : null;
        if (value == null) {
            value = defaultValue;
        }
        if (value instanceof String) {
            value = this.getCamelContext().resolvePropertyPlaceholders(value.toString());
        }
        if (value instanceof String && String.class != type) {
            text = value.toString();
            if (EndpointHelper.isReferenceParameter(text)) {
                List<Object> obj = type == List.class ? EndpointHelper.resolveReferenceListParameter(this.camelContext, text, Object.class) : EndpointHelper.resolveReferenceParameter(this.camelContext, text, type);
                if (obj == null) {
                    throw new NoSuchBeanException(text, type.getName());
                }
                value = obj;
            } else if (type == Long.TYPE || type == Long.class || type == Integer.TYPE || type == Integer.class) {
                Number obj = null;
                try {
                    long num = TimeUtils.toMilliSeconds(text);
                    obj = type == Integer.TYPE || type == Integer.class ? (Number)((int)num) : (Number)num;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (obj != null) {
                    value = obj;
                }
            }
        }
        if (!(type != Boolean.class && type != Boolean.TYPE || !(value instanceof String) || (text = (String)((Object)value)).equalsIgnoreCase("true") || text.equalsIgnoreCase("false"))) {
            throw new IllegalArgumentException("Cannot convert the String value: " + value + " to type: " + type + " as the value is not true or false");
        }
        return this.getCamelContext().getTypeConverter().convertTo(type, value);
    }
}

