/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import com.fasterxml.classmate.Filter;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.RawMethod;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.Contracts;

public final class ExecutableHelper {
    private final TypeResolver typeResolver = new TypeResolver();

    public boolean overrides(ExecutableElement executableElement, ExecutableElement other) {
        if (executableElement.getMember() instanceof Constructor || other.getMember() instanceof Constructor) {
            return false;
        }
        return this.overrides((Method)executableElement.getMember(), (Method)other.getMember());
    }

    public boolean overrides(Method subTypeMethod, Method superTypeMethod) {
        Contracts.assertValueNotNull(subTypeMethod, "subTypeMethod");
        Contracts.assertValueNotNull(superTypeMethod, "superTypeMethod");
        if (subTypeMethod.equals(superTypeMethod)) {
            return false;
        }
        if (!subTypeMethod.getName().equals(superTypeMethod.getName())) {
            return false;
        }
        if (subTypeMethod.getParameterTypes().length != superTypeMethod.getParameterTypes().length) {
            return false;
        }
        if (!superTypeMethod.getDeclaringClass().isAssignableFrom(subTypeMethod.getDeclaringClass())) {
            return false;
        }
        if (Modifier.isStatic(superTypeMethod.getModifiers()) || Modifier.isStatic(subTypeMethod.getModifiers())) {
            return false;
        }
        return this.instanceMethodParametersResolveToSameTypes(subTypeMethod, superTypeMethod);
    }

    private boolean instanceMethodParametersResolveToSameTypes(Method subTypeMethod, Method superTypeMethod) {
        if (subTypeMethod.getParameterTypes().length == 0) {
            return true;
        }
        ResolvedType resolvedSubType = this.typeResolver.resolve(subTypeMethod.getDeclaringClass(), new Type[0]);
        MemberResolver memberResolver = new MemberResolver(this.typeResolver);
        memberResolver.setMethodFilter(new SimpleMethodFilter(subTypeMethod, superTypeMethod));
        ResolvedTypeWithMembers typeWithMembers = memberResolver.resolve(resolvedSubType, null, null);
        ResolvedMethod[] resolvedMethods = typeWithMembers.getMemberMethods();
        if (resolvedMethods.length == 1) {
            return true;
        }
        for (int i = 0; i < resolvedMethods[0].getArgumentCount(); ++i) {
            if (resolvedMethods[0].getArgumentType(i).equals(resolvedMethods[1].getArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    private static class SimpleMethodFilter
    implements Filter<RawMethod> {
        private final Method method1;
        private final Method method2;

        private SimpleMethodFilter(Method method1, Method method2) {
            this.method1 = method1;
            this.method2 = method2;
        }

        @Override
        public boolean include(RawMethod element) {
            return element.getRawMember().equals(this.method1) || element.getRawMember().equals(this.method2);
        }
    }
}

