/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.groups.GroupWithInheritance;
import org.hibernate.validator.internal.engine.groups.Sequence;
import org.hibernate.validator.internal.engine.groups.ValidationOrder;
import org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import org.hibernate.validator.internal.engine.path.NodeImpl;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.engine.resolver.CachingTraversableResolverForSingleValidation;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ExecutableMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.aggregated.PropertyMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ReturnValueMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.facets.Validatable;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.SetAccessibility;
import org.hibernate.validator.spi.time.TimeProvider;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;

public class ValidatorImpl
implements Validator,
ExecutableValidator {
    private static final String TYPE_USE = "TYPE_USE";
    private static final Log log = LoggerFactory.make();
    private static final Collection<Class<?>> DEFAULT_GROUPS = Collections.singletonList(Default.class);
    private final transient ValidationOrderGenerator validationOrderGenerator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final BeanMetaDataManager beanMetaDataManager;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final ParameterNameProvider parameterNameProvider;
    private final TimeProvider timeProvider;
    private final boolean failFast;
    private final TypeResolutionHelper typeResolutionHelper;
    private final List<ValidatedValueUnwrapper<?>> validatedValueHandlers;
    private final ConcurrentMap<Member, Member> accessibleMembers;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, BeanMetaDataManager beanMetaDataManager, ParameterNameProvider parameterNameProvider, TimeProvider timeProvider, TypeResolutionHelper typeResolutionHelper, List<ValidatedValueUnwrapper<?>> validatedValueHandlers, ConstraintValidatorManager constraintValidatorManager, boolean failFast) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.beanMetaDataManager = beanMetaDataManager;
        this.parameterNameProvider = parameterNameProvider;
        this.timeProvider = timeProvider;
        this.typeResolutionHelper = typeResolutionHelper;
        this.validatedValueHandlers = validatedValueHandlers;
        this.constraintValidatorManager = constraintValidatorManager;
        this.failFast = failFast;
        this.validationOrderGenerator = new ValidationOrderGenerator();
        this.accessibleMembers = new ConcurrentReferenceHashMap<Member, Member>(100, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        if (!this.beanMetaDataManager.isConstrained(object.getClass())) {
            return Collections.emptySet();
        }
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> validationContext = this.getValidationContext().forValidate(object);
        ValueContext valueContext = ValueContext.getLocalExecutionContext(object, this.beanMetaDataManager.getBeanMetaData(object.getClass()), PathImpl.createRootPath());
        return this.validateInContext(validationContext, valueContext, validationOrder);
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        this.sanityCheckPropertyPath(propertyName);
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateProperty(object);
        if (!this.beanMetaDataManager.isConstrained(context.getRootBeanClass())) {
            return Collections.emptySet();
        }
        return this.validatePropertyInContext(context, PathImpl.createPathFromString(propertyName), validationOrder);
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Contracts.assertNotNull(beanType, Messages.MESSAGES.beanTypeCannotBeNull());
        if (!this.beanMetaDataManager.isConstrained(beanType)) {
            return Collections.emptySet();
        }
        this.sanityCheckPropertyPath(propertyName);
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateValue(beanType);
        return this.validateValueInContext(context, value, PathImpl.createPathFromString(propertyName), validationOrder);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        Contracts.assertNotNull(parameterValues, Messages.MESSAGES.validatedParameterArrayMustNotBeNull());
        return this.validateParameters(object, ExecutableElement.forMethod(method), parameterValues, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(Constructor<? extends T> constructor, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(constructor, Messages.MESSAGES.validatedConstructorMustNotBeNull());
        Contracts.assertNotNull(parameterValues, Messages.MESSAGES.validatedParameterArrayMustNotBeNull());
        return this.validateParameters(null, ExecutableElement.forConstructor(constructor), parameterValues, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(Constructor<? extends T> constructor, T createdObject, Class<?> ... groups) {
        Contracts.assertNotNull(constructor, Messages.MESSAGES.validatedConstructorMustNotBeNull());
        Contracts.assertNotNull(createdObject, Messages.MESSAGES.validatedConstructorCreatedInstanceMustNotBeNull());
        return this.validateReturnValue(null, ExecutableElement.forConstructor(constructor), createdObject, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        return this.validateReturnValue(object, ExecutableElement.forMethod(method), returnValue, groups);
    }

    private <T> Set<ConstraintViolation<T>> validateParameters(T object, ExecutableElement executable, Object[] parameterValues, Class<?> ... groups) {
        if (parameterValues == null) {
            return Collections.emptySet();
        }
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateParameters(this.parameterNameProvider, object, executable, parameterValues);
        if (!this.beanMetaDataManager.isConstrained(context.getRootBeanClass())) {
            return Collections.emptySet();
        }
        this.validateParametersInContext(context, parameterValues, validationOrder);
        return context.getFailingConstraints();
    }

    private <T> Set<ConstraintViolation<T>> validateReturnValue(T object, ExecutableElement executable, Object returnValue, Class<?> ... groups) {
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateReturnValue(object, executable, returnValue);
        if (!this.beanMetaDataManager.isConstrained(context.getRootBeanClass())) {
            return Collections.emptySet();
        }
        this.validateReturnValueInContext(context, object, returnValue, validationOrder);
        return context.getFailingConstraints();
    }

    @Override
    public final BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.beanMetaDataManager.getBeanMetaData(clazz).getBeanDescriptor();
    }

    @Override
    public final <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(Validator.class)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedForUnwrappingException(type);
    }

    @Override
    public ExecutableValidator forExecutables() {
        return this;
    }

    private ValidationContext.ValidationContextBuilder getValidationContext() {
        return ValidationContext.getValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.timeProvider, this.validatedValueHandlers, this.typeResolutionHelper, this.failFast);
    }

    private void sanityCheckPropertyPath(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw log.getInvalidPropertyPathException();
        }
    }

    private ValidationOrder determineGroupValidationOrder(Class<?>[] groups) {
        Contracts.assertNotNull(groups, Messages.MESSAGES.groupMustNotBeNull());
        for (Class<?> clazz : groups) {
            if (clazz != null) continue;
            throw new IllegalArgumentException(Messages.MESSAGES.groupMustNotBeNull());
        }
        Collection<Class<?>> resultGroups = groups.length == 0 ? DEFAULT_GROUPS : Arrays.asList(groups);
        return this.validationOrderGenerator.getValidationOrder(resultGroups);
    }

    private <T, U> Set<ConstraintViolation<T>> validateInContext(ValidationContext<T> context, ValueContext<U, Object> valueContext, ValidationOrder validationOrder) {
        Group group;
        if (valueContext.getCurrentBean() == null) {
            return Collections.emptySet();
        }
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validateConstraintsForCurrentGroup(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validateCascadedConstraints(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfViolations = context.getFailingConstraints().size();
                for (Group group2 : groupOfGroups) {
                    valueContext.setCurrentGroup(group2.getDefiningClass());
                    this.validateConstraintsForCurrentGroup(context, valueContext);
                    if (this.shouldFailFast(context)) {
                        return context.getFailingConstraints();
                    }
                    this.validateCascadedConstraints(context, valueContext);
                    if (!this.shouldFailFast(context)) continue;
                    return context.getFailingConstraints();
                }
                if (context.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
        return context.getFailingConstraints();
    }

    private void validateConstraintsForCurrentGroup(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        if (!valueContext.validatingDefault()) {
            this.validateConstraintsForNonDefaultGroup(validationContext, valueContext);
        } else {
            this.validateConstraintsForDefaultGroup(validationContext, valueContext);
        }
    }

    private <U> void validateConstraintsForDefaultGroup(ValidationContext<?> validationContext, ValueContext<U, Object> valueContext) {
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<?>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<U> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<U> hostingBeanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            if (defaultGroupSequenceIsRedefined) {
                Iterator<Sequence> defaultGroupSequence = hostingBeanMetaData.getDefaultValidationSequence(valueContext.getCurrentBean());
                Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getMetaConstraints();
                block1: while (defaultGroupSequence.hasNext()) {
                    for (GroupWithInheritance groupOfGroups : defaultGroupSequence.next()) {
                        boolean validationSuccessful = true;
                        for (Group defaultSequenceMember : groupOfGroups) {
                            validationSuccessful = this.validateConstraintsForSingleDefaultGroupElement(validationContext, valueContext, validatedInterfaces, clazz, metaConstraints, defaultSequenceMember);
                        }
                        if (validationSuccessful) continue;
                        continue block1;
                    }
                }
            } else {
                Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
                this.validateConstraintsForSingleDefaultGroupElement(validationContext, valueContext, validatedInterfaces, clazz, metaConstraints, Group.DEFAULT_GROUP);
            }
            validationContext.markCurrentBeanAsProcessed(valueContext);
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
    }

    private <U> boolean validateConstraintsForSingleDefaultGroupElement(ValidationContext<?> validationContext, ValueContext<U, Object> valueContext, Map<Class<?>, Class<?>> validatedInterfaces, Class<? super U> clazz, Set<MetaConstraint<?>> metaConstraints, Group defaultSequenceMember) {
        boolean validationSuccessful = true;
        valueContext.setCurrentGroup(defaultSequenceMember.getDefiningClass());
        PathImpl currentPath = valueContext.getPropertyPath();
        for (MetaConstraint<?> metaConstraint : metaConstraints) {
            Class<?> declaringClass = metaConstraint.getLocation().getDeclaringClass();
            if (declaringClass.isInterface()) {
                Class<?> validatedForClass = validatedInterfaces.get(declaringClass);
                if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                validatedInterfaces.put(declaringClass, clazz);
            }
            boolean tmp = this.validateConstraint(validationContext, valueContext, false, metaConstraint);
            if (this.shouldFailFast(validationContext)) {
                return false;
            }
            validationSuccessful = validationSuccessful && tmp;
            valueContext.setPropertyPath(currentPath);
        }
        return validationSuccessful;
    }

    private void validateConstraintsForNonDefaultGroup(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        BeanMetaData<?> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        PathImpl currentPath = valueContext.getPropertyPath();
        for (MetaConstraint<?> metaConstraint : beanMetaData.getMetaConstraints()) {
            this.validateConstraint(validationContext, valueContext, false, metaConstraint);
            if (this.shouldFailFast(validationContext)) {
                return;
            }
            valueContext.setPropertyPath(currentPath);
        }
        validationContext.markCurrentBeanAsProcessed(valueContext);
    }

    private boolean validateConstraint(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, boolean propertyPathComplete, MetaConstraint<?> metaConstraint) {
        if (metaConstraint.getElementType() != ElementType.TYPE) {
            PropertyMetaData propertyMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType()).getMetaDataFor(metaConstraint.getLocation().getPropertyName());
            if (!propertyPathComplete) {
                valueContext.appendNode(propertyMetaData);
            }
            if (TYPE_USE.equals(metaConstraint.getElementType().name())) {
                valueContext.setUnwrapMode(UnwrapMode.UNWRAP);
            } else {
                valueContext.setUnwrapMode(propertyMetaData.unwrapMode());
            }
        } else {
            valueContext.appendBeanNode();
        }
        boolean validationSuccessful = this.validateMetaConstraint(validationContext, valueContext, metaConstraint);
        valueContext.setUnwrapMode(UnwrapMode.AUTOMATIC);
        return validationSuccessful;
    }

    private boolean validatePropertyTypeConstraint(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, boolean propertyPathComplete, MetaConstraint<?> metaConstraint) {
        PropertyMetaData propertyMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType()).getMetaDataFor(metaConstraint.getLocation().getPropertyName());
        if (!propertyPathComplete) {
            valueContext.appendNode(propertyMetaData);
        }
        valueContext.setUnwrapMode(UnwrapMode.UNWRAP);
        boolean validationSuccessful = this.validateMetaConstraint(validationContext, valueContext, metaConstraint);
        valueContext.setUnwrapMode(UnwrapMode.AUTOMATIC);
        return validationSuccessful;
    }

    private boolean validateMetaConstraint(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, MetaConstraint<?> metaConstraint) {
        if (this.isValidationRequired(validationContext, valueContext, metaConstraint)) {
            if (valueContext.getCurrentBean() != null) {
                Object valueToValidate = this.getBeanMemberValue(valueContext.getCurrentBean(), metaConstraint.getLocation().getMember());
                valueContext.setCurrentValidatedValue(valueToValidate);
            }
            return metaConstraint.validateConstraint(validationContext, valueContext);
        }
        return true;
    }

    private void validateCascadedConstraints(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        Validatable validatable = valueContext.getCurrentValidatable();
        PathImpl originalPath = valueContext.getPropertyPath();
        Class<?> originalGroup = valueContext.getCurrentGroup();
        for (Cascadable cascadable : validatable.getCascadables()) {
            Object value;
            valueContext.appendNode(cascadable);
            Class<?> group = cascadable.convertGroup(originalGroup);
            valueContext.setCurrentGroup(group);
            ElementType elementType = cascadable.getElementType();
            if (this.isCascadeRequired(validationContext, valueContext.getCurrentBean(), valueContext.getPropertyPath(), elementType) && (value = this.getBeanPropertyValue(validationContext, valueContext.getCurrentBean(), cascadable)) != null) {
                ValidationOrder validationOrder = this.validationOrderGenerator.getValidationOrder(group, group != originalGroup);
                Class<?> type = value.getClass();
                if (ReflectionHelper.isIterable(type) || ReflectionHelper.isMap(type)) {
                    Iterator<Object> valueIter = Collections.singletonList(value).iterator();
                    this.validateCascadedConstraint(validationContext, valueContext, valueIter, false, validationOrder, Collections.<MetaConstraint<?>>emptySet());
                    if (this.shouldFailFast(validationContext)) {
                        return;
                    }
                }
                Iterator<?> elementsIter = this.createIteratorForCascadedValue(valueContext, type, value);
                boolean isIndexable = ReflectionHelper.isIndexable(type);
                this.validateCascadedConstraint(validationContext, valueContext, elementsIter, isIndexable, validationOrder, cascadable.getTypeArgumentsConstraints());
                if (this.shouldFailFast(validationContext)) {
                    return;
                }
            }
            valueContext.setPropertyPath(originalPath);
            valueContext.setCurrentGroup(originalGroup);
        }
    }

    private Iterator<?> createIteratorForCascadedValue(ValueContext<?, ?> valueContext, Type type, Object value) {
        Iterator<Object> iter;
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (ReflectionHelper.isMap(type)) {
            Map map = (Map)value;
            iter = map.entrySet().iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (TypeHelper.isArray(type)) {
            List<Object> arrayList = Arrays.asList((Object[])value);
            iter = arrayList.iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else {
            iter = Collections.singletonList(value).iterator();
        }
        return iter;
    }

    private void validateCascadedConstraint(ValidationContext<?> context, ValueContext<?, Object> valueContext, Iterator<?> iter, boolean isIndexable, ValidationOrder validationOrder, Set<MetaConstraint<?>> typeArgumentsConstraint) {
        int i = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof Map.Entry) {
                Object mapKey = ((Map.Entry)value).getKey();
                valueContext.setKey(mapKey);
                value = ((Map.Entry)value).getValue();
            } else if (isIndexable) {
                valueContext.setIndex(i);
            }
            if (!context.isBeanAlreadyValidated(value, valueContext.getCurrentGroup(), valueContext.getPropertyPath())) {
                this.validateTypeArgumentConstraints(context, this.buildNewLocalExecutionContext(valueContext, value), value, typeArgumentsConstraint);
                this.validateInContext(context, this.buildNewLocalExecutionContext(valueContext, value), validationOrder);
                if (this.shouldFailFast(context)) {
                    return;
                }
            }
            ++i;
        }
    }

    private ValueContext<?, Object> buildNewLocalExecutionContext(ValueContext<?, Object> valueContext, Object value) {
        ValueContext newValueContext = value != null ? ValueContext.getLocalExecutionContext(value, this.beanMetaDataManager.getBeanMetaData(value.getClass()), valueContext.getPropertyPath()) : ValueContext.getLocalExecutionContext(valueContext.getCurrentBeanType(), this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType()), valueContext.getPropertyPath());
        return newValueContext;
    }

    private void validateTypeArgumentConstraints(ValidationContext<?> context, ValueContext<?, Object> valueContext, Object value, Set<MetaConstraint<?>> typeArgumentsConstraints) {
        valueContext.setCurrentValidatedValue(value);
        valueContext.appendCollectionElementNode();
        for (MetaConstraint<Object> metaConstraint : typeArgumentsConstraints) {
            metaConstraint.validateConstraint(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return;
        }
    }

    private <T> Set<ConstraintViolation<T>> validatePropertyInContext(ValidationContext<T> context, PathImpl propertyPath, ValidationOrder validationOrder) {
        ArrayList<MetaConstraint<?>> typeUseConstraints;
        ArrayList<MetaConstraint<?>> metaConstraints = CollectionHelper.newArrayList();
        ValueContext valueContext = this.collectMetaConstraintsForPathWithValue(context, propertyPath, metaConstraints, typeUseConstraints = CollectionHelper.newArrayList());
        if (valueContext.getCurrentBean() == null) {
            throw log.getUnableToReachPropertyToValidateException(context.getRootBean(), propertyPath);
        }
        if (metaConstraints.size() == 0 && typeUseConstraints.size() == 0) {
            return context.getFailingConstraints();
        }
        this.assertDefaultGroupSequenceIsExpandable(valueContext, validationOrder);
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validatePropertyForCurrentGroup(context, valueContext, metaConstraints, typeUseConstraints);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfConstraintViolations = 0;
                for (Group group : groupOfGroups) {
                    valueContext.setCurrentGroup(group.getDefiningClass());
                    numberOfConstraintViolations += this.validatePropertyForCurrentGroup(context, valueContext, metaConstraints, typeUseConstraints);
                    if (!this.shouldFailFast(context)) continue;
                    return context.getFailingConstraints();
                }
                if (numberOfConstraintViolations <= 0) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private <T> void assertDefaultGroupSequenceIsExpandable(ValueContext<T, ?> valueContext, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
    }

    private <T> Set<ConstraintViolation<T>> validateValueInContext(ValidationContext<T> context, Object value, PathImpl propertyPath, ValidationOrder validationOrder) {
        ArrayList<MetaConstraint<?>> metaConstraints = CollectionHelper.newArrayList();
        ArrayList<MetaConstraint<?>> typeArgumentConstraints = CollectionHelper.newArrayList();
        ValueContext<T, Object> valueContext = this.collectMetaConstraintsForPathWithoutValue(context, propertyPath, metaConstraints, typeArgumentConstraints);
        valueContext.setCurrentValidatedValue(value);
        if (metaConstraints.size() == 0 && typeArgumentConstraints.size() == 0) {
            return context.getFailingConstraints();
        }
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(null));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validatePropertyForCurrentGroup(context, valueContext, metaConstraints, typeArgumentConstraints);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfConstraintViolations = 0;
                for (Group group : groupOfGroups) {
                    valueContext.setCurrentGroup(group.getDefiningClass());
                    numberOfConstraintViolations += this.validatePropertyForCurrentGroup(context, valueContext, metaConstraints, typeArgumentConstraints);
                    if (!this.shouldFailFast(context)) continue;
                    return context.getFailingConstraints();
                }
                if (numberOfConstraintViolations <= 0) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private int validatePropertyForCurrentGroup(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, List<MetaConstraint<?>> metaConstraints, List<MetaConstraint<?>> typeUseConstraints) {
        if (!valueContext.validatingDefault()) {
            return this.validatePropertyForNonDefaultGroup(validationContext, valueContext, metaConstraints, typeUseConstraints);
        }
        return this.validatePropertyForDefaultGroup(validationContext, valueContext, metaConstraints, typeUseConstraints);
    }

    private int validatePropertyForNonDefaultGroup(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, List<MetaConstraint<?>> metaConstraints, List<MetaConstraint<?>> typeArgumentConstraints) {
        int numberOfConstraintViolationsBefore = validationContext.getFailingConstraints().size();
        for (MetaConstraint<?> metaConstraint : metaConstraints) {
            this.validateConstraint(validationContext, valueContext, true, metaConstraint);
            if (!this.shouldFailFast(validationContext)) continue;
            return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
        }
        for (MetaConstraint<?> metaConstraint : typeArgumentConstraints) {
            this.validatePropertyTypeConstraint(validationContext, valueContext, true, metaConstraint);
            if (!this.shouldFailFast(validationContext)) continue;
            return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
        }
        return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
    }

    private <U> int validatePropertyForDefaultGroup(ValidationContext<?> validationContext, ValueContext<U, Object> valueContext, List<MetaConstraint<?>> constraintList, List<MetaConstraint<?>> typeUseConstraints) {
        int numberOfConstraintViolationsBefore = validationContext.getFailingConstraints().size();
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<?>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<U> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<U> hostingBeanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            if (defaultGroupSequenceIsRedefined) {
                Iterator<Sequence> defaultGroupSequence = hostingBeanMetaData.getDefaultValidationSequence(valueContext.getCurrentBean());
                Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getMetaConstraints();
                block1: while (defaultGroupSequence.hasNext()) {
                    for (GroupWithInheritance groupOfGroups : defaultGroupSequence.next()) {
                        boolean validationSuccessful = true;
                        for (Group groupClass : groupOfGroups) {
                            validationSuccessful = this.validatePropertyForSingleDefaultGroupElement(validationContext, valueContext, constraintList, typeUseConstraints, validatedInterfaces, clazz, metaConstraints, groupClass);
                        }
                        if (validationSuccessful) continue;
                        continue block1;
                    }
                }
            } else {
                Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
                this.validatePropertyForSingleDefaultGroupElement(validationContext, valueContext, constraintList, typeUseConstraints, validatedInterfaces, clazz, metaConstraints, Group.DEFAULT_GROUP);
            }
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
    }

    private <U> boolean validatePropertyForSingleDefaultGroupElement(ValidationContext<?> validationContext, ValueContext<U, Object> valueContext, List<MetaConstraint<?>> constraintList, List<MetaConstraint<?>> typeUseConstraints, Map<Class<?>, Class<?>> validatedInterfaces, Class<? super U> clazz, Set<MetaConstraint<?>> metaConstraints, Group groupClass) {
        valueContext.setCurrentGroup(groupClass.getDefiningClass());
        boolean validationSuccessful = true;
        for (MetaConstraint<?> metaConstraint : metaConstraints) {
            Class<?> declaringClass = metaConstraint.getLocation().getDeclaringClass();
            if (declaringClass.isInterface()) {
                Class<?> validatedForClass = validatedInterfaces.get(declaringClass);
                if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                validatedInterfaces.put(declaringClass, clazz);
            }
            if (constraintList.contains(metaConstraint)) {
                boolean tmp = this.validateConstraint(validationContext, valueContext, true, metaConstraint);
                boolean bl = validationSuccessful = validationSuccessful && tmp;
                if (this.shouldFailFast(validationContext)) {
                    return false;
                }
            }
            if (!typeUseConstraints.contains(metaConstraint)) continue;
            boolean tmp = this.validatePropertyTypeConstraint(validationContext, valueContext, true, metaConstraint);
            boolean bl = validationSuccessful = validationSuccessful && tmp;
            if (!this.shouldFailFast(validationContext)) continue;
            return false;
        }
        return validationSuccessful;
    }

    private <T> void validateParametersInContext(ValidationContext<T> validationContext, Object[] parameterValues, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        if (executableMetaData == null) {
            throw log.getMethodOrConstructorNotDefinedByValidatedTypeException(beanMetaData.getBeanClass(), validationContext.getExecutable().getMember());
        }
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(validationContext.getRootBean()));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateParametersForGroup(validationContext, parameterValues, groupIterator.next());
            if (!this.shouldFailFast(validationContext)) continue;
            return;
        }
        ValueContext cascadingValueContext = ValueContext.getLocalExecutionContext(parameterValues, (Validatable)executableMetaData.getValidatableParametersMetaData(), PathImpl.createPathForExecutable(executableMetaData));
        cascadingValueContext.setUnwrapMode(executableMetaData.unwrapMode());
        groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            cascadingValueContext.setCurrentGroup(group.getDefiningClass());
            this.validateCascadedConstraints(validationContext, cascadingValueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            return;
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfViolations = validationContext.getFailingConstraints().size();
                for (Group group : groupOfGroups) {
                    this.validateParametersForGroup(validationContext, parameterValues, group);
                    if (this.shouldFailFast(validationContext)) {
                        return;
                    }
                    cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                    this.validateCascadedConstraints(validationContext, cascadingValueContext);
                    if (!this.shouldFailFast(validationContext)) continue;
                    return;
                }
                if (validationContext.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
    }

    private <T> void validateParametersForGroup(ValidationContext<T> validationContext, Object[] parameterValues, Group group) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        if (parameterValues.length != executableMetaData.getParameterTypes().length) {
            throw log.getInvalidParameterCountForExecutableException(ExecutableElement.getExecutableAsString(executableMetaData.getType().toString() + "#" + executableMetaData.getName(), executableMetaData.getParameterTypes()), parameterValues.length, executableMetaData.getParameterTypes().length);
        }
        if (group.isDefaultGroup()) {
            Iterator<Sequence> defaultGroupSequence = beanMetaData.getDefaultValidationSequence(validationContext.getRootBean());
            while (defaultGroupSequence.hasNext()) {
                Sequence sequence = defaultGroupSequence.next();
                int numberOfViolations = validationContext.getFailingConstraints().size();
                for (GroupWithInheritance expandedGroup : sequence) {
                    for (Group defaultGroupSequenceElement : expandedGroup) {
                        this.validateParametersForSingleGroup(validationContext, parameterValues, executableMetaData, defaultGroupSequenceElement.getDefiningClass());
                        if (!this.shouldFailFast(validationContext)) continue;
                        return;
                    }
                    if (validationContext.getFailingConstraints().size() <= numberOfViolations) continue;
                    return;
                }
            }
        } else {
            this.validateParametersForSingleGroup(validationContext, parameterValues, executableMetaData, group.getDefiningClass());
        }
    }

    private <T> void validateParametersForSingleGroup(ValidationContext<T> validationContext, Object[] parameterValues, ExecutableMetaData executableMetaData, Class<?> currentValidatedGroup) {
        ValueContext<T, Object> valueContext = this.getExecutableValueContext(validationContext.getRootBean(), executableMetaData, currentValidatedGroup);
        valueContext.appendCrossParameterNode();
        valueContext.setCurrentValidatedValue(parameterValues);
        this.validateConstraintsForGroup(validationContext, valueContext, executableMetaData.getCrossParameterConstraints());
        if (this.shouldFailFast(validationContext)) {
            return;
        }
        valueContext = this.getExecutableValueContext(validationContext.getRootBean(), executableMetaData, currentValidatedGroup);
        valueContext.setCurrentValidatedValue(parameterValues);
        for (int i = 0; i < parameterValues.length; ++i) {
            PathImpl originalPath = valueContext.getPropertyPath();
            ParameterMetaData parameterMetaData = executableMetaData.getParameterMetaData(i);
            Object value = parameterValues[i];
            if (value != null) {
                Class<?> valueType = value.getClass();
                if (parameterMetaData.getType() instanceof Class && ((Class)parameterMetaData.getType()).isPrimitive()) {
                    valueType = ReflectionHelper.unBoxedType(valueType);
                }
                if (!TypeHelper.isAssignable(TypeHelper.getErasedType(parameterMetaData.getType()), valueType)) {
                    throw log.getParameterTypesDoNotMatchException(valueType, parameterMetaData.getType(), i, validationContext.getExecutable().getMember());
                }
            }
            valueContext.appendNode(parameterMetaData);
            valueContext.setUnwrapMode(parameterMetaData.unwrapMode());
            valueContext.setCurrentValidatedValue(value);
            this.validateConstraintsForGroup(validationContext, valueContext, parameterMetaData);
            if (this.shouldFailFast(validationContext)) {
                return;
            }
            if (!parameterMetaData.isCascading()) {
                this.validateConstraintsForGroup(validationContext, valueContext, parameterMetaData.getTypeArgumentsConstraints());
                if (this.shouldFailFast(validationContext)) {
                    return;
                }
            }
            valueContext.setPropertyPath(originalPath);
        }
    }

    private <T> ValueContext<T, Object> getExecutableValueContext(T object, ExecutableMetaData executableMetaData, Class<?> group) {
        ValueContext valueContext = object != null ? ValueContext.getLocalExecutionContext(object, null, PathImpl.createPathForExecutable(executableMetaData)) : ValueContext.getLocalExecutionContext((Class)null, null, PathImpl.createPathForExecutable(executableMetaData));
        valueContext.setCurrentGroup(group);
        return valueContext;
    }

    private <V, T> void validateReturnValueInContext(ValidationContext<T> context, T bean, V value, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(context.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(context.getExecutable());
        if (executableMetaData == null) {
            return;
        }
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(bean));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateReturnValueForGroup(context, bean, value, groupIterator.next());
            if (!this.shouldFailFast(context)) continue;
            return;
        }
        ValueContext cascadingValueContext = null;
        if (value != null) {
            cascadingValueContext = ValueContext.getLocalExecutionContext(value, (Validatable)executableMetaData.getReturnValueMetaData(), PathImpl.createPathForExecutable(executableMetaData));
            groupIterator = validationOrder.getGroupIterator();
            while (groupIterator.hasNext()) {
                Group group = groupIterator.next();
                cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                this.validateCascadedConstraints(context, cascadingValueContext);
                if (!this.shouldFailFast(context)) continue;
                return;
            }
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfFailingConstraintsBeforeGroup = context.getFailingConstraints().size();
                for (Group group : groupOfGroups) {
                    this.validateReturnValueForGroup(context, bean, value, group);
                    if (this.shouldFailFast(context)) {
                        return;
                    }
                    if (value == null) continue;
                    cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                    this.validateCascadedConstraints(context, cascadingValueContext);
                    if (!this.shouldFailFast(context)) continue;
                    return;
                }
                if (context.getFailingConstraints().size() <= numberOfFailingConstraintsBeforeGroup) continue;
                continue block2;
            }
        }
    }

    private <T> void validateReturnValueForGroup(ValidationContext<T> validationContext, T bean, Object value, Group group) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        if (executableMetaData == null) {
            return;
        }
        if (group.isDefaultGroup()) {
            Iterator<Sequence> defaultGroupSequence = beanMetaData.getDefaultValidationSequence(bean);
            while (defaultGroupSequence.hasNext()) {
                Sequence sequence = defaultGroupSequence.next();
                int numberOfViolations = validationContext.getFailingConstraints().size();
                for (GroupWithInheritance expandedGroup : sequence) {
                    for (Group defaultGroupSequenceElement : expandedGroup) {
                        this.validateReturnValueForSingleGroup(validationContext, executableMetaData, bean, value, defaultGroupSequenceElement.getDefiningClass());
                        if (!this.shouldFailFast(validationContext)) continue;
                        return;
                    }
                    if (validationContext.getFailingConstraints().size() <= numberOfViolations) continue;
                    return;
                }
            }
        } else {
            this.validateReturnValueForSingleGroup(validationContext, executableMetaData, bean, value, group.getDefiningClass());
        }
    }

    private <T> void validateReturnValueForSingleGroup(ValidationContext<T> validationContext, ExecutableMetaData executableMetaData, T bean, Object value, Class<?> oneGroup) {
        ValueContext<Object, Object> valueContext = this.getExecutableValueContext(executableMetaData.getKind() == ElementKind.CONSTRUCTOR ? value : bean, executableMetaData, oneGroup);
        valueContext.setCurrentValidatedValue(value);
        ReturnValueMetaData returnValueMetaData = executableMetaData.getReturnValueMetaData();
        valueContext.appendNode(returnValueMetaData);
        valueContext.setUnwrapMode(returnValueMetaData.unwrapMode());
        this.validateConstraintsForGroup(validationContext, valueContext, returnValueMetaData);
        if (this.shouldFailFast(validationContext)) {
            return;
        }
        if (!returnValueMetaData.isCascading()) {
            this.validateConstraintsForGroup(validationContext, valueContext, returnValueMetaData.getTypeArgumentsConstraints());
            if (this.shouldFailFast(validationContext)) {
                return;
            }
        }
    }

    private void validateConstraintsForGroup(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext, Iterable<MetaConstraint<?>> constraints) {
        for (MetaConstraint<?> metaConstraint : constraints) {
            if (!this.isValidationRequired(validationContext, valueContext, metaConstraint)) continue;
            metaConstraint.validateConstraint(validationContext, valueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            break;
        }
    }

    private <V> ValueContext<?, V> collectMetaConstraintsForPathWithValue(ValidationContext<?> validationContext, PathImpl propertyPath, List<MetaConstraint<?>> metaConstraints, List<MetaConstraint<?>> typeArgumentConstraints) {
        Class<?> clazz = validationContext.getRootBeanClass();
        Object value = validationContext.getRootBean();
        AbstractConstraintMetaData propertyMetaData = null;
        Iterator<Path.Node> propertyPathIter = propertyPath.iterator();
        while (propertyPathIter.hasNext()) {
            NodeImpl propertyPathNode = (NodeImpl)propertyPathIter.next();
            propertyMetaData = this.getBeanPropertyMetaData(clazz, propertyPathNode);
            if (!propertyPathIter.hasNext()) continue;
            if (!propertyMetaData.isCascading()) {
                throw log.getInvalidPropertyPathException(validationContext.getRootBeanClass(), propertyPath.asString());
            }
            if ((value = this.getBeanPropertyValue(validationContext, value, (Cascadable)((Object)propertyMetaData))) == null) {
                throw log.getUnableToReachPropertyToValidateException(validationContext.getRootBean(), propertyPath);
            }
            clazz = value.getClass();
            if (!propertyPathNode.isIterable()) continue;
            propertyPathNode = (NodeImpl)propertyPathIter.next();
            if (propertyPathNode.getIndex() != null) {
                value = ReflectionHelper.getIndexedValue(value, propertyPathNode.getIndex());
            } else if (propertyPathNode.getKey() != null) {
                value = ReflectionHelper.getMappedValue(value, propertyPathNode.getKey());
            } else {
                throw log.getPropertyPathMustProvideIndexOrMapKeyException();
            }
            if (value == null) {
                throw log.getUnableToReachPropertyToValidateException(validationContext.getRootBean(), propertyPath);
            }
            clazz = value.getClass();
            propertyMetaData = this.getBeanPropertyMetaData(clazz, propertyPathNode);
        }
        if (propertyMetaData == null) {
            throw log.getInvalidPropertyPathException(clazz, propertyPath.asString());
        }
        metaConstraints.addAll(propertyMetaData.getConstraints());
        typeArgumentConstraints.addAll(((PropertyMetaData)propertyMetaData).getTypeArgumentsConstraints());
        return ValueContext.getLocalExecutionContext(value, null, propertyPath);
    }

    private <V> ValueContext<?, V> collectMetaConstraintsForPathWithoutValue(ValidationContext<?> validationContext, PathImpl propertyPath, List<MetaConstraint<?>> metaConstraints, List<MetaConstraint<?>> typeArgumentConstraints) {
        Class<?> clazz = validationContext.getRootBeanClass();
        AbstractConstraintMetaData propertyMetaData = null;
        Iterator<Path.Node> propertyPathIter = propertyPath.iterator();
        while (propertyPathIter.hasNext()) {
            NodeImpl propertyPathNode = (NodeImpl)propertyPathIter.next();
            propertyMetaData = this.getBeanPropertyMetaData(clazz, propertyPathNode);
            if (!propertyPathIter.hasNext()) continue;
            if (propertyPathNode.isIterable()) {
                propertyPathNode = (NodeImpl)propertyPathIter.next();
                clazz = ReflectionHelper.getClassFromType(ReflectionHelper.getCollectionElementType(propertyMetaData.getType()));
                propertyMetaData = this.getBeanPropertyMetaData(clazz, propertyPathNode);
                continue;
            }
            clazz = ReflectionHelper.getClassFromType(propertyMetaData.getType());
        }
        if (propertyMetaData == null) {
            throw log.getInvalidPropertyPathException(clazz, propertyPath.asString());
        }
        metaConstraints.addAll(propertyMetaData.getConstraints());
        typeArgumentConstraints.addAll(((PropertyMetaData)propertyMetaData).getTypeArgumentsConstraints());
        return ValueContext.getLocalExecutionContext(clazz, null, propertyPath);
    }

    private TraversableResolver getCachingTraversableResolver() {
        return new CachingTraversableResolverForSingleValidation(this.traversableResolver);
    }

    private boolean isValidationRequired(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext, MetaConstraint<?> metaConstraint) {
        if (validationContext.hasMetaConstraintBeenProcessed(valueContext.getCurrentBean(), valueContext.getPropertyPath(), metaConstraint)) {
            return false;
        }
        if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) {
            return false;
        }
        return this.isReachable(validationContext, valueContext.getCurrentBean(), valueContext.getPropertyPath(), metaConstraint.getElementType());
    }

    private boolean isReachable(ValidationContext<?> validationContext, Object traversableObject, PathImpl path, ElementType type) {
        if (this.needToCallTraversableResolver(path, type)) {
            return true;
        }
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            return validationContext.getTraversableResolver().isReachable(traversableObject, path.getLeafNode(), validationContext.getRootBeanClass(), pathToObject, type);
        }
        catch (RuntimeException e) {
            throw log.getErrorDuringCallOfTraversableResolverIsReachableException(e);
        }
    }

    private boolean needToCallTraversableResolver(PathImpl path, ElementType type) {
        return this.isClassLevelConstraint(type) || this.isCrossParameterValidation(path) || this.isParameterValidation(path) || this.isReturnValueValidation(path);
    }

    private boolean isCascadeRequired(ValidationContext<?> validationContext, Object traversableObject, PathImpl path, ElementType type) {
        if (this.needToCallTraversableResolver(path, type)) {
            return true;
        }
        boolean isReachable = this.isReachable(validationContext, traversableObject, path, type);
        if (!isReachable) {
            return false;
        }
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            return validationContext.getTraversableResolver().isCascadable(traversableObject, path.getLeafNode(), validationContext.getRootBeanClass(), pathToObject, type);
        }
        catch (RuntimeException e) {
            throw log.getErrorDuringCallOfTraversableResolverIsCascadableException(e);
        }
    }

    private boolean isClassLevelConstraint(ElementType type) {
        return ElementType.TYPE.equals((Object)type);
    }

    private boolean isCrossParameterValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.CROSS_PARAMETER;
    }

    private boolean isParameterValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.PARAMETER;
    }

    private boolean isReturnValueValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.RETURN_VALUE;
    }

    private boolean shouldFailFast(ValidationContext<?> context) {
        return context.isFailFastModeEnabled() && !context.getFailingConstraints().isEmpty();
    }

    private PropertyMetaData getBeanPropertyMetaData(Class<?> beanClass, Path.Node propertyNode) {
        if (!ElementKind.PROPERTY.equals((Object)propertyNode.getKind())) {
            throw log.getInvalidPropertyPathException(beanClass, propertyNode.getName());
        }
        BeanMetaData<?> beanMetaData = this.beanMetaDataManager.getBeanMetaData(beanClass);
        PropertyMetaData propertyMetaData = beanMetaData.getMetaDataFor(propertyNode.getName());
        if (propertyMetaData == null) {
            throw log.getInvalidPropertyPathException(beanClass, propertyNode.getName());
        }
        return propertyMetaData;
    }

    private Object getBeanPropertyValue(ValidationContext<?> validationContext, Object object, Cascadable cascadable) {
        ValidatedValueUnwrapper<?> valueHandler;
        Object value = cascadable.getValue(object);
        UnwrapMode unwrapMode = cascadable.unwrapMode();
        if ((UnwrapMode.UNWRAP.equals((Object)unwrapMode) || UnwrapMode.AUTOMATIC.equals((Object)unwrapMode)) && (valueHandler = validationContext.getValidatedValueUnwrapper(cascadable.getCascadableType())) != null) {
            value = valueHandler.handleValidatedValue(value);
        }
        return value;
    }

    private Object getBeanMemberValue(Object object, Member member) {
        if (member == null) {
            return object;
        }
        if ((member = this.getAccessible(member)) instanceof Method) {
            return ReflectionHelper.getValue((Method)member, object);
        }
        if (member instanceof Field) {
            return ReflectionHelper.getValue((Field)member, object);
        }
        return null;
    }

    private Member getAccessible(Member original) {
        if (((AccessibleObject)((Object)original)).isAccessible()) {
            return original;
        }
        Member member = (Member)this.accessibleMembers.get(original);
        if (member != null) {
            return member;
        }
        Class<?> clazz = original.getDeclaringClass();
        member = original instanceof Field ? (Member)this.run(GetDeclaredField.action(clazz, original.getName())) : (Member)this.run(GetDeclaredMethod.action(clazz, original.getName(), new Class[0]));
        this.run(SetAccessibility.action(member));
        Member cached = this.accessibleMembers.putIfAbsent(original, member);
        if (cached != null) {
            member = cached;
        }
        return member;
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

