/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk.processors;

import com.surftools.BeanstalkClient.Client;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.BeanstalkExchangeHelper;
import org.apache.camel.component.beanstalk.processors.DefaultCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCommand
extends DefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteCommand.class);

    public DeleteCommand(BeanstalkEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void act(Client client, Exchange exchange) throws NoSuchHeaderException {
        Long jobId = BeanstalkExchangeHelper.getJobID(exchange);
        boolean result = client.delete(jobId);
        if (!result && LOG.isWarnEnabled()) {
            LOG.warn(String.format("Failed to delete job %d", jobId));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Job %d deleted. Result is %b", jobId, result));
        }
        this.answerWith(exchange, "beanstalk.result", result);
    }
}

