/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk.processors;

import com.surftools.BeanstalkClient.Client;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.processors.DefaultCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KickCommand
extends DefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(KickCommand.class);

    public KickCommand(BeanstalkEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void act(Client client, Exchange exchange) throws NoSuchHeaderException, InvalidPayloadException {
        Integer jobs = (Integer)exchange.getIn().getMandatoryBody(Integer.class);
        int result = client.kick(jobs);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Kick %d jobs. Kicked %d actually.", jobs, result));
        }
        Message answer = this.getAnswerMessage(exchange);
        answer.setBody((Object)result, Integer.class);
    }
}

