/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk.processors;

import com.surftools.BeanstalkClient.Client;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.BeanstalkExchangeHelper;
import org.apache.camel.component.beanstalk.processors.DefaultCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseCommand
extends DefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReleaseCommand.class);

    public ReleaseCommand(BeanstalkEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void act(Client client, Exchange exchange) throws NoSuchHeaderException {
        Message in = exchange.getIn();
        Long jobId = BeanstalkExchangeHelper.getJobID(exchange);
        long priority = BeanstalkExchangeHelper.getPriority(this.endpoint, in);
        int delay = BeanstalkExchangeHelper.getDelay(this.endpoint, in);
        boolean result = client.release(jobId, priority, delay);
        if (!result && LOG.isWarnEnabled()) {
            LOG.warn(String.format("Failed to release job %d (priority %d, delay %d)", jobId, priority, delay));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Job %d released with priority %d, delay %d seconds. Result is %b", jobId, priority, delay, result));
        }
        this.answerWith(exchange, "beanstalk.result", result);
    }
}

