/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk.processors;

import com.surftools.BeanstalkClient.Client;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.processors.DefaultCommand;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchCommand
extends DefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TouchCommand.class);

    public TouchCommand(BeanstalkEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void act(Client client, Exchange exchange) throws NoSuchHeaderException {
        Long jobId = (Long)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"beanstalk.jobId", Long.class);
        boolean result = client.touch(jobId);
        if (!result && LOG.isWarnEnabled()) {
            LOG.warn(String.format("Failed to touch job %d", jobId));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Job %d touched. Result is %b", jobId, result));
        }
        this.answerWith(exchange, "beanstalk.result", result);
    }
}

