/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.AbstractNumberFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class DoubleFormatFactory
extends AbstractFormatFactory {
    public DoubleFormatFactory() {
        this.supportedClasses.add(Double.TYPE);
        this.supportedClasses.add(Double.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isEmpty((Object)formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new DoubleFormat(formattingOptions.isImpliedDecimalSeparator(), formattingOptions.getPrecision(), formattingOptions.getLocale());
    }

    private static class DoubleFormat
    extends AbstractNumberFormat<Double> {
        DoubleFormat(boolean impliedDecimalPosition, int precision, Locale locale) {
            super(impliedDecimalPosition, precision, locale);
        }

        @Override
        public String format(Double object) throws Exception {
            return !super.hasImpliedDecimalPosition() ? super.getFormat().format(object) : super.getFormat().format(object * super.getMultiplier());
        }

        @Override
        public Double parse(String string) throws Exception {
            Double value = null;
            if (!super.hasImpliedDecimalPosition()) {
                value = Double.parseDouble(string.trim());
            } else {
                BigDecimal tmp = new BigDecimal(string.trim());
                BigDecimal div = BigDecimal.valueOf(super.getMultiplier());
                value = tmp.divide(div).doubleValue();
            }
            return value;
        }
    }
}

