/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.NumberPatternFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class BytePatternFormatFactory
extends AbstractFormatFactory {
    public BytePatternFormatFactory() {
        this.supportedClasses.add(Byte.TYPE);
        this.supportedClasses.add(Byte.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isNotEmpty(formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new BytePatternFormat(formattingOptions.getPattern(), formattingOptions.getLocale());
    }

    private static class BytePatternFormat
    extends NumberPatternFormat<Byte> {
        BytePatternFormat(String pattern, Locale locale) {
            super(pattern, locale);
        }

        @Override
        public Byte parse(String string) throws Exception {
            if (this.getNumberFormat() != null) {
                return this.getNumberFormat().parse(string).byteValue();
            }
            return Byte.valueOf(string);
        }
    }
}

