/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.AbstractNumberFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class IntegerFormatFactory
extends AbstractFormatFactory {
    private final IntegerFormat integerFormat = new IntegerFormat();

    public IntegerFormatFactory() {
        this.supportedClasses.add(Integer.TYPE);
        this.supportedClasses.add(Integer.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isEmpty(formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return this.integerFormat;
    }

    private static class IntegerFormat
    extends AbstractNumberFormat<Integer> {
        private IntegerFormat() {
        }

        @Override
        public String format(Integer object) throws Exception {
            return object.toString();
        }

        @Override
        public Integer parse(String string) throws Exception {
            return Integer.valueOf(string);
        }
    }
}

