/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.AbstractNumberFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class LongFormatFactory
extends AbstractFormatFactory {
    private final LongFormat longFormat = new LongFormat();

    public LongFormatFactory() {
        this.supportedClasses.add(Long.TYPE);
        this.supportedClasses.add(Long.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isEmpty(formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return this.longFormat;
    }

    private static class LongFormat
    extends AbstractNumberFormat<Long> {
        private LongFormat() {
        }

        @Override
        public String format(Long object) throws Exception {
            return object.toString();
        }

        @Override
        public Long parse(String string) throws Exception {
            return Long.valueOf(string);
        }
    }
}

