/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.AbstractNumberFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class ShortFormatFactory
extends AbstractFormatFactory {
    private final ShortFormat shortFormat = new ShortFormat();

    public ShortFormatFactory() {
        this.supportedClasses.add(Short.TYPE);
        this.supportedClasses.add(Short.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isEmpty(formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return this.shortFormat;
    }

    private static class ShortFormat
    extends AbstractNumberFormat<Short> {
        private ShortFormat() {
        }

        @Override
        public String format(Short object) throws Exception {
            return object.toString();
        }

        @Override
        public Short parse(String string) throws Exception {
            return Short.valueOf(string);
        }
    }
}

