/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.PatternFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class ZonedDateTimeFormatFactory
extends AbstractFormatFactory {
    public ZonedDateTimeFormatFactory() {
        this.supportedClasses.add(ZonedDateTime.class);
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new ZonedDateTimePatternFormat(formattingOptions.getPattern(), formattingOptions.getLocale());
    }

    private static class ZonedDateTimePatternFormat
    implements PatternFormat<ZonedDateTime> {
        private String pattern;
        private Locale locale;

        ZonedDateTimePatternFormat(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        @Override
        public String format(ZonedDateTime object) throws Exception {
            ObjectHelper.notNull(this.pattern, "pattern");
            return this.getDateFormat().format(object);
        }

        @Override
        public ZonedDateTime parse(String string) throws Exception {
            DateTimeFormatter df = this.getDateFormat();
            ObjectHelper.notNull(this.pattern, "pattern");
            return ZonedDateTime.parse(string, df);
        }

        DateTimeFormatter getDateFormat() {
            DateTimeFormatter result = this.locale != null ? DateTimeFormatter.ofPattern(this.pattern, this.locale) : DateTimeFormatter.ofPattern(this.pattern);
            return result;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

