/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.util;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.dataformat.bindy.annotation.CsvRecord;
import org.apache.camel.dataformat.bindy.annotation.FixedLengthRecord;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.Message;
import org.apache.camel.dataformat.bindy.annotation.Section;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;

public class AnnotationModelLoader {
    private PackageScanClassResolver resolver;
    private PackageScanFilter filter;
    private Set<Class<? extends Annotation>> annotations;

    public AnnotationModelLoader(PackageScanClassResolver resolver) {
        this.resolver = resolver;
        this.annotations = new LinkedHashSet<Class<? extends Annotation>>();
        this.annotations.add(CsvRecord.class);
        this.annotations.add(Link.class);
        this.annotations.add(Message.class);
        this.annotations.add(Section.class);
        this.annotations.add(FixedLengthRecord.class);
    }

    public AnnotationModelLoader(PackageScanClassResolver resolver, PackageScanFilter filter) {
        this(resolver);
        this.filter = filter;
    }

    public Set<Class<?>> loadModels(String ... packageNames) {
        Set results = this.resolver.findAnnotated(this.annotations, packageNames);
        HashSet resultsToRemove = new HashSet();
        if (this.filter != null) {
            for (Class<?> clazz : results) {
                if (this.filter.matches(clazz)) continue;
                resultsToRemove.add(clazz);
            }
        }
        results.removeAll(resultsToRemove);
        return results;
    }
}

