/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class ByteFormatFactory
extends AbstractFormatFactory {
    private final ByteFormat byteFormat = new ByteFormat();

    public ByteFormatFactory() {
        this.supportedClasses.add(Byte.TYPE);
        this.supportedClasses.add(Byte.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isEmpty(formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return this.byteFormat;
    }

    private static class ByteFormat
    implements Format<Byte> {
        private ByteFormat() {
        }

        @Override
        public String format(Byte object) throws Exception {
            return object.toString();
        }

        @Override
        public Byte parse(String string) throws Exception {
            return Byte.valueOf(string);
        }
    }
}

