/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.AbstractNumberFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class FloatFormatFactory
extends AbstractFormatFactory {
    public FloatFormatFactory() {
        this.supportedClasses.add(Float.TYPE);
        this.supportedClasses.add(Float.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isEmpty(formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new FloatFormat(formattingOptions.isImpliedDecimalSeparator(), formattingOptions.getPrecision(), formattingOptions.getLocale());
    }

    private static class FloatFormat
    extends AbstractNumberFormat<Float> {
        FloatFormat(boolean impliedDecimalPosition, int precision, Locale locale) {
            super(impliedDecimalPosition, precision, locale);
        }

        @Override
        public String format(Float object) throws Exception {
            return !super.hasImpliedDecimalPosition() ? super.getFormat().format(object) : super.getFormat().format((double)object.floatValue() * super.getMultiplier());
        }

        @Override
        public Float parse(String string) throws Exception {
            Float value;
            if (!super.hasImpliedDecimalPosition()) {
                value = Float.valueOf(Float.parseFloat(string.trim()));
            } else {
                BigDecimal tmp = new BigDecimal(string.trim());
                BigDecimal div = BigDecimal.valueOf(super.getMultiplier());
                value = Float.valueOf(tmp.divide(div).floatValue());
            }
            return value;
        }
    }
}

