/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Sets;
import org.boon.Str;
import org.boon.StringScanner;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.TypeType;
import org.boon.core.Value;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.Mapper;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.primitive.CharBuf;
import org.boon.primitive.CharScanner;

public class BeanUtils {
    static Map<String, String[]> splitsPathsCache = new ConcurrentHashMap<String, String[]>();

    public static Object getPropByPath(Object item, String ... path) {
        Object o = item;
        for (int index = 0; index < path.length; ++index) {
            String propName = path[index];
            if (o == null) {
                return null;
            }
            if (o.getClass().isArray() || o instanceof Collection) {
                o = BeanUtils.getCollectionProp(o, propName, index, path);
                break;
            }
            o = BeanUtils.getProp(o, propName);
        }
        return Conversions.unifyListOrArray(o);
    }

    private static Map<String, FieldAccess> getPropertyFieldAccessMap(Class<?> clazz) {
        return Reflection.getPropertyFieldAccessMapFieldFirst(clazz);
    }

    public static FieldAccess getField(Class clazz, String name) {
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(clazz);
        if (fields != null) {
            return fields.get(name);
        }
        return null;
    }

    public static FieldAccess getField(Object object, String name) {
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        if (fields != null) {
            return fields.get(name);
        }
        return null;
    }

    public static Map<String, FieldAccess> getFieldsFromObject(Class<?> cls) {
        return BeanUtils.getPropertyFieldAccessMap(cls);
    }

    public static Map<String, FieldAccess> getFieldsFromObject(Object object) {
        try {
            Map<String, FieldAccess> fields = object instanceof Map ? BeanUtils.getFieldsFromMap((Map)object) : BeanUtils.getPropertyFieldAccessMap(object.getClass());
            return fields;
        }
        catch (Exception ex) {
            Exceptions.requireNonNull(object, "Item cannot be null");
            return Exceptions.handle(Map.class, ex, "Unable to get fields from object", Boon.className(object));
        }
    }

    private static Map<String, FieldAccess> getFieldsFromMap(final Map<String, Object> map) {
        return new Map<String, FieldAccess>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return map.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return true;
            }

            @Override
            public FieldAccess get(final Object key) {
                return new FieldAccess(){

                    @Override
                    public boolean injectable() {
                        return false;
                    }

                    @Override
                    public boolean requiresInjection() {
                        return false;
                    }

                    @Override
                    public boolean isNamed() {
                        return false;
                    }

                    @Override
                    public boolean hasAlias() {
                        return false;
                    }

                    @Override
                    public String alias() {
                        return null;
                    }

                    @Override
                    public String named() {
                        return key.toString();
                    }

                    @Override
                    public String name() {
                        return key.toString();
                    }

                    @Override
                    public Object getValue(Object obj) {
                        return map.get(key);
                    }

                    @Override
                    public void setValue(Object obj, Object value) {
                        map.put(key.toString(), value);
                    }

                    @Override
                    public void setFromValue(Object obj, Value value) {
                        map.put(key.toString(), value.toValue());
                    }

                    @Override
                    public boolean getBoolean(Object obj) {
                        return Conversions.toBoolean(this.getValue(key));
                    }

                    @Override
                    public void setBoolean(Object obj, boolean value) {
                        this.setValue(map, value);
                    }

                    @Override
                    public int getInt(Object obj) {
                        return Conversions.toInt(this.getValue(key));
                    }

                    @Override
                    public void setInt(Object obj, int value) {
                        this.setValue(map, value);
                    }

                    @Override
                    public short getShort(Object obj) {
                        return Conversions.toShort(this.getValue(key));
                    }

                    @Override
                    public void setShort(Object obj, short value) {
                        this.setValue(map, value);
                    }

                    @Override
                    public char getChar(Object obj) {
                        return Conversions.toChar(this.getValue(key));
                    }

                    @Override
                    public void setChar(Object obj, char value) {
                        this.setValue(map, Character.valueOf(value));
                    }

                    @Override
                    public long getLong(Object obj) {
                        return Conversions.toChar(this.getValue(key));
                    }

                    @Override
                    public void setLong(Object obj, long value) {
                        this.setValue(map, value);
                    }

                    @Override
                    public double getDouble(Object obj) {
                        return Conversions.toDouble(this.getValue(key));
                    }

                    @Override
                    public void setDouble(Object obj, double value) {
                        this.setValue(map, value);
                    }

                    @Override
                    public float getFloat(Object obj) {
                        return Conversions.toFloat(this.getValue(key));
                    }

                    @Override
                    public void setFloat(Object obj, float value) {
                        this.setValue(map, Float.valueOf(value));
                    }

                    @Override
                    public byte getByte(Object obj) {
                        return Conversions.toByte(this.getValue(key));
                    }

                    @Override
                    public void setByte(Object obj, byte value) {
                        this.setValue(map, value);
                    }

                    @Override
                    public Object getObject(Object obj) {
                        return this.getValue(obj);
                    }

                    @Override
                    public void setObject(Object obj, Object value) {
                        this.setValue(obj, value);
                    }

                    @Override
                    public TypeType typeEnum() {
                        return TypeType.OBJECT;
                    }

                    @Override
                    public boolean isPrimitive() {
                        return false;
                    }

                    @Override
                    public boolean isFinal() {
                        return false;
                    }

                    @Override
                    public boolean isStatic() {
                        return false;
                    }

                    @Override
                    public boolean isVolatile() {
                        return false;
                    }

                    @Override
                    public boolean isQualified() {
                        return false;
                    }

                    @Override
                    public boolean isReadOnly() {
                        return false;
                    }

                    @Override
                    public boolean isWriteOnly() {
                        return false;
                    }

                    @Override
                    public Class<?> type() {
                        return Object.class;
                    }

                    @Override
                    public Class<?> declaringParent() {
                        return null;
                    }

                    @Override
                    public Object parent() {
                        return map;
                    }

                    @Override
                    public Field getField() {
                        return null;
                    }

                    @Override
                    public boolean include() {
                        return true;
                    }

                    @Override
                    public boolean ignore() {
                        return false;
                    }

                    @Override
                    public ParameterizedType getParameterizedType() {
                        return null;
                    }

                    @Override
                    public Class<?> getComponentClass() {
                        return null;
                    }

                    @Override
                    public boolean hasAnnotation(String annotationName) {
                        return false;
                    }

                    @Override
                    public Map<String, Object> getAnnotationData(String annotationName) {
                        return null;
                    }

                    @Override
                    public boolean isViewActive(String activeView) {
                        return false;
                    }

                    @Override
                    public void setStaticValue(Object newValue) {
                    }

                    @Override
                    public TypeType componentType() {
                        return null;
                    }
                };
            }

            @Override
            public FieldAccess put(String key, FieldAccess value) {
                return null;
            }

            @Override
            public FieldAccess remove(Object key) {
                return null;
            }

            @Override
            public void putAll(Map<? extends String, ? extends FieldAccess> m) {
            }

            @Override
            public void clear() {
            }

            @Override
            public Set<String> keySet() {
                return null;
            }

            @Override
            public Collection<FieldAccess> values() {
                return null;
            }

            @Override
            public Set<Map.Entry<String, FieldAccess>> entrySet() {
                return null;
            }
        };
    }

    public static void setPropertyValue(Object root, Object newValue, String ... properties) {
        Object object = root;
        int index = 0;
        try {
            for (String property : properties) {
                Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
                FieldAccess field = fields.get(property);
                if (StringScanner.isDigits(property)) {
                    object = BeanUtils.idx(object, StringScanner.parseInt(property));
                } else {
                    if (field == null) {
                        Exceptions.die(Boon.sputs("We were unable to access property=", property, "\nThe properties passed were=", properties, "\nThe root object is =", root.getClass().getName(), "\nThe current object is =", object.getClass().getName()));
                    }
                    if (index == properties.length - 1) {
                        field.setValue(object, newValue);
                    } else {
                        object = field.getObject(object);
                    }
                }
                ++index;
            }
        }
        catch (Exception ex) {
            Exceptions.requireNonNull(root, "Root cannot be null");
            Exceptions.handle(ex, "Unable to set property for root object", Boon.className(root), "for property path", properties, "with new value", newValue, "last object in the tree was", Boon.className(object), "current property index", index);
        }
    }

    public static void setPropertyValue(Class<?> root, Object newValue, String ... properties) {
        Object object = root;
        int index = 0;
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(root);
        try {
            for (String property : properties) {
                FieldAccess field = fields.get(property);
                if (StringScanner.isDigits(property)) {
                    object = BeanUtils.idx(object, StringScanner.parseInt(property));
                } else {
                    if (field == null) {
                        Exceptions.die(Boon.sputs("We were unable to access property=", property, "\nThe properties passed were=", properties, "\nThe root object is =", root.getClass().getName(), "\nThe current object is =", object.getClass().getName()));
                    }
                    if (index == properties.length - 1) {
                        if (object instanceof Class) {
                            field.setStaticValue(newValue);
                        } else {
                            field.setValue(object, newValue);
                        }
                    } else if ((object = field.getObject(object)) != null) {
                        fields = BeanUtils.getFieldsFromObject(root);
                    }
                }
                ++index;
            }
        }
        catch (Exception ex) {
            Exceptions.requireNonNull(root, "Root cannot be null");
            Exceptions.handle(ex, "Unable to set property for root object", Boon.className(root), "for property path", properties, "with new value", newValue, "last object in the tree was", Boon.className(object), "current property index", index);
        }
    }

    public static Object getPropertyValue(Object root, String ... properties) {
        Object object = root;
        for (String property : properties) {
            if (object == null) {
                return null;
            }
            if (property.equals("this")) {
                Object aThis;
                if (!(object instanceof Map) || (aThis = ((Map)object).get("this")) == null) continue;
                object = aThis;
                continue;
            }
            if (object instanceof Map) {
                object = ((Map)object).get(property);
                continue;
            }
            char c = property.charAt(0);
            if (CharScanner.isDigit(c)) {
                object = BeanUtils.idx(object, StringScanner.parseInt(property));
                continue;
            }
            if (object instanceof Collection) {
                object = BeanUtils._getFieldValuesFromCollectionOrArray(object, property);
                continue;
            }
            if (Typ.isArray(object)) {
                Iterator iter = Conversions.iterator(object);
                List list = Lists.list(iter);
                object = BeanUtils._getFieldValuesFromCollectionOrArray(list, property);
                continue;
            }
            Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
            FieldAccess field = fields.get(property);
            if (field == null) {
                return null;
            }
            object = field.getValue(object);
        }
        return object;
    }

    public static Class<?> getPropertyType(Object root, String property) {
        Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(root.getClass());
        FieldAccess field = fields.get(property);
        return field.type();
    }

    public static <T> T idxGeneric(Class<T> t, Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return (T)BeanUtils.getPropertyValue(object, properties);
    }

    public static <T> List<T> idxList(Class<T> cls, Object items, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return (List)BeanUtils.getPropByPath(items, properties);
    }

    public static List idxList(Object items, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return (List)BeanUtils.getPropByPath(items, properties);
    }

    public static <T> List<T> idxRecurse(Class<T> cls, Object items, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return (List)BeanUtils.getPropByPath(items, properties);
    }

    public static List idxRecurse(Object items, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return (List)BeanUtils.getPropByPath(items, properties);
    }

    public static Object idx(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyValue(object, properties);
    }

    public static Object indexOf(Object object, String path) {
        return BeanUtils.atIndex(object, path);
    }

    public static Object atIndex(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyValue(object, properties);
    }

    private static String[] propertyPathAsStringArray(String path) {
        String[] split = splitsPathsCache.get(path);
        if (split != null) {
            return split;
        }
        split = StringScanner.splitByCharsNoneEmpty(path, '.', '[', ']', '/');
        splitsPathsCache.put(path, split);
        return split;
    }

    public static Object findProperty(Object context, String propertyPath) {
        String defaultValue;
        int index = propertyPath.indexOf(124);
        if (index != -1) {
            String[] splitByPipe = Str.splitByPipe(propertyPath);
            defaultValue = splitByPipe[1];
            propertyPath = splitByPipe[0];
        } else {
            defaultValue = null;
        }
        Iterator iterator = Conversions.iterator(context);
        while (iterator.hasNext()) {
            Object ctx = iterator.next();
            Object object = BeanUtils.idx(ctx, propertyPath);
            if (object == null) continue;
            if (object instanceof List) {
                List list = (List)object;
                int nulls = 0;
                for (Object o : list) {
                    if (o != null) continue;
                    ++nulls;
                }
                if (nulls == list.size()) break;
            }
            return object;
        }
        return defaultValue;
    }

    public static void injectIntoProperty(Object object, String path, Object value) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        BeanUtils.setPropertyValue(object, value, properties);
    }

    public static void idx(Object object, String path, Object value) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        BeanUtils.setPropertyValue(object, value, properties);
    }

    public static void idx(Class<?> cls, String path, Object value) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        BeanUtils.setPropertyValue(cls, value, properties);
    }

    private static Object getCollectionProp(Object o, String propName, int index, String[] path) {
        o = BeanUtils._getFieldValuesFromCollectionOrArray(o, propName);
        if (index + 1 == path.length) {
            return o;
        }
        return BeanUtils.getCollectionProp(o, path[++index], index, path);
    }

    public static Object getProp(Object object, String property) {
        Class<?> cls;
        Map<String, FieldAccess> fields;
        if (object == null) {
            return null;
        }
        if (StringScanner.isDigits(property)) {
            object = BeanUtils.idx(object, StringScanner.parseInt(property));
        }
        if (!(fields = Reflection.getPropertyFieldAccessors(cls = object.getClass())).containsKey(property)) {
            fields = Reflection.getAllAccessorFields(cls);
        }
        if (!fields.containsKey(property)) {
            return null;
        }
        return fields.get(property).getValue(object);
    }

    public static int getPropertyInt(Object root, String ... properties) {
        String lastProperty = properties[properties.length - 1];
        if (StringScanner.isDigits(lastProperty)) {
            return Conversions.toInt(BeanUtils.getPropertyValue(root, properties));
        }
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.intgr) {
            return field.getInt(object);
        }
        return Conversions.toInt(field.getValue(object));
    }

    private static Object baseForGetProperty(Object root, String[] properties) {
        Object object = root;
        Map<String, FieldAccess> fields = null;
        for (int index = 0; index < properties.length - 1; ++index) {
            if (object == null) {
                return null;
            }
            String property = properties[index];
            if (property.equals("this")) continue;
            if (StringScanner.isDigits(property)) {
                object = BeanUtils.idx(object, StringScanner.parseInt(property));
                continue;
            }
            if (object instanceof Collection) {
                object = BeanUtils._getFieldValuesFromCollectionOrArray(object, property);
                continue;
            }
            if (Typ.isArray(object)) {
                Iterator iter = Conversions.iterator(object);
                List list = Lists.list(iter);
                object = BeanUtils._getFieldValuesFromCollectionOrArray(list, property);
                continue;
            }
            fields = BeanUtils.getPropertyFieldAccessMap(object.getClass());
            FieldAccess field = fields.get(property);
            if (field == null) {
                return null;
            }
            object = field.getObject(object);
        }
        return object;
    }

    private static Class<?> baseForGetProperty(Class<?> root, String[] properties) {
        Class<?> cls = root;
        Map<String, FieldAccess> fields = null;
        for (int index = 0; index < properties.length - 1; ++index) {
            fields = BeanUtils.getPropertyFieldAccessMap(cls);
            String property = properties[index];
            FieldAccess field = fields.get(property);
            cls = field.type();
        }
        return cls;
    }

    public static int idxInt(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyInt(object, properties);
    }

    public static String idxStr(Object object, String path) {
        Object val = BeanUtils.idx(object, path);
        return Conversions.toString(val);
    }

    private static String getPropertyString(Object root, String[] properties) {
        String lastProperty;
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty = properties[properties.length - 1]);
        if (field.type() == Typ.string) {
            return (String)field.getObject(object);
        }
        return Conversions.toString(field.getValue(object));
    }

    public static byte getPropertyByte(Object root, String ... properties) {
        String lastProperty = properties[properties.length - 1];
        if (StringScanner.isDigits(lastProperty)) {
            return Conversions.toByte(BeanUtils.getPropertyValue(root, properties));
        }
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.bt) {
            return field.getByte(object);
        }
        return Conversions.toByte(field.getValue(object));
    }

    public static byte idxByte(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyByte(object, properties);
    }

    public static float getPropertyFloat(Object root, String ... properties) {
        String lastProperty = properties[properties.length - 1];
        if (StringScanner.isDigits(lastProperty)) {
            return Conversions.toFloat(BeanUtils.getPropertyValue(root, properties));
        }
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.flt) {
            return field.getFloat(object);
        }
        return Conversions.toFloat(field.getValue(object));
    }

    public static float idxFloat(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyFloat(object, properties);
    }

    public static short getPropertyShort(Object root, String ... properties) {
        String lastProperty = properties[properties.length - 1];
        if (StringScanner.isDigits(lastProperty)) {
            return Conversions.toShort(BeanUtils.getPropertyValue(root, properties));
        }
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.shrt) {
            return field.getShort(object);
        }
        return Conversions.toShort(field.getValue(object));
    }

    public static Class<?> getPropertyPathType(Object root, String ... properties) {
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        String lastProperty = properties[properties.length - 1];
        FieldAccess field = fields.get(lastProperty);
        return field.type();
    }

    public static FieldAccess getPropertyPathField(Object root, String ... properties) {
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        String lastProperty = properties[properties.length - 1];
        FieldAccess field = fields.get(lastProperty);
        return field;
    }

    public static FieldAccess getPropertyPathField(Class root, String ... properties) {
        Class<?> cls = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(cls);
        String lastProperty = properties[properties.length - 1];
        FieldAccess field = fields.get(lastProperty);
        return field;
    }

    public static short idxShort(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyShort(object, properties);
    }

    public static Class idxType(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyPathType(object, properties);
    }

    public static FieldAccess idxField(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyPathField(object, properties);
    }

    public static FieldAccess idxField(Class<?> cls, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyPathField(cls, properties);
    }

    public static char getPropertyChar(Object root, String ... properties) {
        String lastProperty = properties[properties.length - 1];
        if (StringScanner.isDigits(lastProperty)) {
            return Conversions.toChar(BeanUtils.getPropertyValue(root, properties));
        }
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.chr) {
            return field.getChar(object);
        }
        return Conversions.toChar(field.getValue(object));
    }

    public static char idxChar(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyChar(object, properties);
    }

    public static double getPropertyDouble(Object root, String ... properties) {
        String lastProperty = properties[properties.length - 1];
        if (StringScanner.isDigits(lastProperty)) {
            return Conversions.toDouble(BeanUtils.getPropertyValue(root, properties));
        }
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.dbl) {
            return field.getDouble(object);
        }
        return Conversions.toDouble(field.getValue(object));
    }

    public static double idxDouble(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyDouble(object, properties);
    }

    public static long getPropertyLong(Object root, String ... properties) {
        String lastProperty = properties[properties.length - 1];
        if (StringScanner.isDigits(lastProperty)) {
            return Conversions.toLong(BeanUtils.getPropertyValue(root, properties));
        }
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.lng) {
            return field.getLong(object);
        }
        return Conversions.toLong(field.getValue(object));
    }

    public static long idxLong(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyLong(object, properties);
    }

    public static boolean getPropertyBoolean(Object root, String ... properties) {
        String lastProperty = properties[properties.length - 1];
        if (StringScanner.isDigits(lastProperty)) {
            return Conversions.toBoolean(BeanUtils.getPropertyValue(root, properties));
        }
        Object object = BeanUtils.baseForGetProperty(root, properties);
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(object);
        FieldAccess field = fields.get(lastProperty);
        if (field.type() == Typ.bln) {
            return field.getBoolean(object);
        }
        return Conversions.toBoolean(field.getValue(object));
    }

    public static boolean idxBoolean(Object object, String path) {
        String[] properties = BeanUtils.propertyPathAsStringArray(path);
        return BeanUtils.getPropertyBoolean(object, properties);
    }

    public static <V> Map<String, V> collectionToMap(String propertyKey, Collection<V> values) {
        LinkedHashMap<String, V> map = new LinkedHashMap<String, V>(values.size());
        for (V v : values) {
            String key = BeanUtils.idxGeneric(Typ.string, v, propertyKey);
            map.put(key, v);
        }
        return map;
    }

    public static void copyPropertiesFromMap(Object dest, Map<String, Object> src) {
        Set<Map.Entry<String, Object>> props = src.entrySet();
        for (Map.Entry<String, Object> entry : props) {
            if (entry.getValue() instanceof Map) {
                Object newDest = dest instanceof Map ? ((Map)dest).get(entry.getKey()) : BeanUtils.getPropByPath(dest, entry.getKey());
                if (newDest == null && dest instanceof Map) {
                    newDest = new LinkedHashMap();
                    ((Map)dest).put(entry.getKey(), newDest);
                }
                Map newSrc = (Map)entry.getValue();
                BeanUtils.copyPropertiesFromMap(newDest, newSrc);
                continue;
            }
            BeanUtils.setPropertyValue(dest, entry.getValue(), entry.getKey());
        }
    }

    public static void copyProperties(Object object, Map<String, Object> properties) {
        Set<Map.Entry<String, Object>> props = properties.entrySet();
        for (Map.Entry<String, Object> entry : props) {
            BeanUtils.setPropertyValue(object, entry.getValue(), entry.getKey());
        }
    }

    private static Object _getFieldValuesFromCollectionOrArray(Object object, String key) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> list = new ArrayList<Object>(collection.size());
            Class<?> lastClass = null;
            Map<String, FieldAccess> fields = null;
            FieldAccess field = null;
            for (Object item : collection) {
                if (item instanceof Map) {
                    Map map = (Map)item;
                    list.add(map.get(key));
                    continue;
                }
                Class<?> currentClass = Boon.cls(item);
                if (lastClass == null || currentClass != lastClass) {
                    fields = BeanUtils.getPropertyFieldAccessMap(currentClass);
                    field = fields.get(key);
                    lastClass = currentClass;
                }
                if (field == null) {
                    list.add(BeanUtils.idx(item, key));
                    continue;
                }
                list.add(field.getValue(item));
            }
            return list;
        }
        if (object.getClass().isArray()) {
            int len = Array.getLength(object);
            ArrayList<Object> list = new ArrayList<Object>(len);
            Map<String, FieldAccess> fields = BeanUtils.getPropertyFieldAccessMap(object.getClass().getComponentType());
            for (int index = 0; index < len; ++index) {
                list.add(fields.get(key).getValue(Array.get(object, index)));
            }
            return list;
        }
        return BeanUtils.atIndex(object, key);
    }

    public static <T> T copy(T item) {
        if (item instanceof Cloneable) {
            return (T)ClassMeta.classMeta(item.getClass()).invokeUntyped(item, "clone", null);
        }
        return BeanUtils.fieldByFieldCopy(item);
    }

    public static <T> T fieldByFieldCopy(T item) {
        Class<?> aClass = item.getClass();
        Map<String, FieldAccess> fields = Reflection.getAllAccessorFields(aClass);
        Object clone = Reflection.newInstance(aClass);
        for (FieldAccess field : fields.values()) {
            try {
                if (field.isStatic() || field.isWriteOnly()) continue;
                if (field.isPrimitive()) {
                    field.setValue(clone, field.getValue(item));
                    continue;
                }
                Object value = field.getObject(item);
                if (value == null) {
                    field.setObject(clone, null);
                    continue;
                }
                if (!field.isPrimitive() && !Typ.isBasicType(field.type())) {
                    field.setObject(clone, BeanUtils.copy(value));
                    continue;
                }
                if (Typ.isBasicType(field.type())) {
                    field.setObject(clone, value);
                    continue;
                }
                if (Typ.isCollection(field.type())) {
                    Collection src = (Collection)value;
                    Class<?> collectionType = field.type();
                    Collection<Object> dst = Conversions.createCollection(collectionType, src.size());
                    for (Object o : src) {
                        dst.add(BeanUtils.copy(o));
                    }
                    field.setObject(clone, dst);
                    continue;
                }
                if (Typ.isMap(field.type()) || !field.type().isArray()) continue;
                int length = Array.getLength(value);
                Object dst = Array.newInstance(field.getComponentClass(), length);
                for (int index = 0; index < length; ++index) {
                    Object o = Array.get(value, index);
                    Array.set(dst, index, BeanUtils.copy(o));
                }
                field.setObject(clone, dst);
            }
            catch (Exception ex) {
                return (T)Exceptions.handle(Object.class, "" + field, ex);
            }
        }
        return (T)clone;
    }

    public static void copyProperties(Object src, Object dest) {
        BeanUtils.fieldByFieldCopy(src, dest);
    }

    public static <T> T createFromSrc(Object src, Class<T> dest) {
        T instance = Reflection.newInstance(dest);
        BeanUtils.fieldByFieldCopy(src, instance);
        return instance;
    }

    public static void copyProperties(Object src, Object dest, String ... ignore) {
        BeanUtils.fieldByFieldCopy(src, dest, Sets.set(ignore));
    }

    public static void copyProperties(Object src, Object dest, Set<String> ignore) {
        BeanUtils.fieldByFieldCopy(src, dest, ignore);
    }

    private static void fieldByFieldCopy(Object src, Object dst, Set<String> ignore) {
        Class<?> srcClass = src.getClass();
        Map<String, FieldAccess> srcFields = Reflection.getAllAccessorFields(srcClass);
        Class<?> dstClass = dst.getClass();
        Map<String, FieldAccess> dstFields = Reflection.getAllAccessorFields(dstClass);
        for (FieldAccess srcField : srcFields.values()) {
            if (ignore.contains(srcField.name())) continue;
            FieldAccess dstField = dstFields.get(srcField.name());
            try {
                BeanUtils.copySrcFieldToDestField(src, dst, dstField, srcField, ignore);
            }
            catch (Exception ex) {
                Exceptions.handle(Boon.sputs("copying field", srcField.name(), srcClass, " to ", dstField.name(), dstClass), (Throwable)ex);
            }
        }
    }

    private static void fieldByFieldCopy(Object src, Object dst) {
        Class<?> srcClass = src.getClass();
        Map<String, FieldAccess> srcFields = Reflection.getAllAccessorFields(srcClass);
        Class<?> dstClass = dst.getClass();
        Map<String, FieldAccess> dstFields = Reflection.getAllAccessorFields(dstClass);
        for (FieldAccess srcField : srcFields.values()) {
            FieldAccess dstField = dstFields.get(srcField.name());
            try {
                BeanUtils.copySrcFieldToDestField(src, dst, dstField, srcField, null);
            }
            catch (Exception ex) {
                Exceptions.handle(Boon.sputs("copying field", srcField.name(), srcClass, " to ", dstField.name(), dstClass), (Throwable)ex);
            }
        }
    }

    private static void copySrcFieldToDestField(Object src, Object dst, FieldAccess dstField, FieldAccess srcField, Set<String> ignore) {
        if (srcField.isStatic()) {
            return;
        }
        if (dstField == null) {
            return;
        }
        if (srcField.isPrimitive()) {
            dstField.setValue(dst, srcField.getValue(src));
            return;
        }
        Object srcValue = srcField.getObject(src);
        if (srcValue == null) {
            if (!dstField.isPrimitive()) {
                dstField.setObject(dst, null);
            }
            return;
        }
        if (Typ.isBasicType(srcField.type())) {
            Object value = srcField.getObject(src);
            dstField.setValue(dst, value);
            return;
        }
        if (!(srcValue instanceof Collection) && dstField.type() == srcValue.getClass() || Typ.isSuperType(dstField.type(), srcValue.getClass())) {
            dstField.setObject(dst, BeanUtils.copy(srcField.getObject(src)));
            return;
        }
        if (srcValue instanceof Collection && dstField.getComponentClass() != null && Typ.isCollection(dstField.type())) {
            BeanUtils.handleCollectionFieldCopy(dst, dstField, (Collection)srcValue);
            return;
        }
        if (dstField.typeEnum() != TypeType.ABSTRACT && dstField.typeEnum() != TypeType.INTERFACE) {
            Object newInstance = Reflection.newInstance(dstField.type());
            if (ignore == null) {
                BeanUtils.fieldByFieldCopy(srcField.getObject(src), newInstance);
            } else {
                BeanUtils.fieldByFieldCopy(srcField.getObject(src), newInstance, ignore);
            }
            dstField.setObject(dst, newInstance);
        }
    }

    private static void handleCollectionFieldCopy(Object dst, FieldAccess dstField, Collection srcValue) {
        if (dstField.getComponentClass() != Typ.string) {
            Collection<Object> dstCollection = Conversions.createCollection(dstField.type(), srcValue.size());
            for (Object srcComponentValue : srcValue) {
                Object newInstance = Reflection.newInstance(dstField.getComponentClass());
                BeanUtils.fieldByFieldCopy(srcComponentValue, newInstance);
                dstCollection.add(newInstance);
            }
            dstField.setObject(dst, dstCollection);
        } else {
            Collection<Object> dstCollection = Conversions.createCollection(dstField.type(), srcValue.size());
            for (Object srcComponentValue : srcValue) {
                if (srcComponentValue == null) continue;
                dstCollection.add(srcComponentValue.toString());
            }
            dstField.setObject(dst, dstCollection);
        }
    }

    public static Object idx(Object object, int index) {
        if (Boon.isArray(object)) {
            object = Array.get(object, index);
        } else if (object instanceof List) {
            object = Lists.idx((List)object, index);
        }
        return object;
    }

    public static void idx(Object object, int index, Object value) {
        try {
            if (Boon.isArray(object)) {
                Array.set(object, index, value);
            } else if (object instanceof List) {
                Lists.idx((List)object, index, value);
            }
        }
        catch (Exception notExpected) {
            String msg = Str.lines("An unexpected error has occurred", "This is likely a programming error!", String.format("Object is %s, index is %s, and set is %s", object, index, value), String.format("The object is an array? %s", object == null ? "null" : Boolean.valueOf(object.getClass().isArray())), String.format("The object is of type %s", object == null ? "null" : object.getClass().getName()), String.format("The set is of type %s", value == null ? "null" : value.getClass().getName()), "");
            Exceptions.handle(msg, (Throwable)notExpected);
        }
    }

    public static <T> T idx(Class<T> type, Object object, String property) {
        return (T)BeanUtils.idx(object, property);
    }

    public static <T> T atIndex(Class<T> type, Object object, String property) {
        return (T)BeanUtils.idx(object, property);
    }

    public static boolean isPropPath(String prop) {
        if (prop.contains(".")) {
            return true;
        }
        if (prop.equals("this")) {
            return true;
        }
        return prop.contains("[");
    }

    public static void setCollectionProperty(Collection<?> list, String propertyName, Object value) {
        for (Object object : list) {
            BeanUtils.idx(object, propertyName, value);
        }
    }

    public static void setIterableProperty(Iterable<?> list, String propertyName, Object value) {
        for (Object object : list) {
            BeanUtils.idx(object, propertyName, value);
        }
    }

    public static String asPrettyJsonString(Object bean) {
        CharBuf buf = CharBuf.createCharBuf();
        return buf.prettyPrintBean(bean).toString();
    }

    public static String asPrettyJsonString(Mapper mapper, Object bean) {
        CharBuf buf = CharBuf.createCharBuf();
        return buf.prettyPrintBean(mapper, bean).toString();
    }
}

