/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.serializers.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Maps;
import org.boon.Str;
import org.boon.cache.SimpleCache;
import org.boon.core.TypeType;
import org.boon.core.Value;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.json.serializers.JsonSerializerInternal;
import org.boon.primitive.CharBuf;

public class JsonSimpleSerializerImpl
implements JsonSerializerInternal {
    private final Map<Class<?>, Map<String, FieldAccess>> fieldMap = new ConcurrentHashMap();
    private final String view;
    private final boolean encodeStrings;
    private final boolean serializeAsSupport;
    private final CharBuf builder;
    private int level;
    private boolean asciiOnly;
    SimpleCache<String, String> stringCache;
    CharBuf encodedJsonChars;
    private static final char[] EMPTY_MAP_CHARS = new char[]{'{', '}'};
    private static final char[] EMPTY_LIST_CHARS = new char[]{'[', ']'};

    public JsonSimpleSerializerImpl() {
        this.view = null;
        this.encodeStrings = true;
        this.serializeAsSupport = true;
        this.builder = CharBuf.create(4000);
    }

    public JsonSimpleSerializerImpl(boolean encodeStrings) {
        this.view = null;
        this.encodeStrings = encodeStrings;
        this.serializeAsSupport = true;
        this.builder = CharBuf.create(4000);
    }

    public JsonSimpleSerializerImpl(String view, boolean encodeStrings, boolean serializeAsSupport, boolean asciiOnly) {
        this.encodeStrings = encodeStrings;
        this.serializeAsSupport = serializeAsSupport;
        this.view = view;
        this.builder = CharBuf.create(4000);
        this.asciiOnly = asciiOnly;
    }

    @Override
    public final void serializeString(String str, CharBuf builder) {
        if (this.encodeStrings) {
            String encodedString;
            if (this.stringCache == null) {
                this.stringCache = new SimpleCache(1000);
                this.encodedJsonChars = CharBuf.create(str.length());
            }
            if ((encodedString = this.stringCache.get(str)) == null) {
                this.encodedJsonChars.asJsonString(str, this.asciiOnly);
                encodedString = this.encodedJsonChars.toStringAndRecycle();
                this.stringCache.put(str, encodedString);
            }
            builder.add(encodedString);
        } else {
            builder.addQuoted(str);
        }
    }

    @Override
    public CharBuf serialize(Object obj) {
        this.level = 0;
        this.builder.readForRecycle();
        try {
            this.serializeObject(obj, this.builder);
        }
        catch (Exception ex) {
            return Exceptions.handle(CharBuf.class, "unable to serializeObject", ex);
        }
        return this.builder;
    }

    @Override
    public void serialize(CharBuf builder, Object obj) {
        this.level = 0;
        try {
            this.serializeObject(obj, builder);
        }
        catch (Exception ex) {
            Exceptions.handle("unable to serializeObject", (Throwable)ex);
        }
    }

    @Override
    public final boolean serializeField(Object parent, FieldAccess fieldAccess, CharBuf builder) {
        String fieldName = fieldAccess.name();
        TypeType typeEnum = fieldAccess.typeEnum();
        if (this.view != null && !fieldAccess.isViewActive(this.view)) {
            return false;
        }
        switch (typeEnum) {
            case INT: {
                int value = fieldAccess.getInt(parent);
                if (value != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addInt(value);
                    return true;
                }
                return false;
            }
            case BOOLEAN: {
                boolean bvalue = fieldAccess.getBoolean(parent);
                if (bvalue) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addBoolean(bvalue);
                    return true;
                }
                return false;
            }
            case BYTE: {
                byte byvalue = fieldAccess.getByte(parent);
                if (byvalue != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addByte(byvalue);
                    return true;
                }
                return false;
            }
            case LONG: {
                long lvalue = fieldAccess.getLong(parent);
                if (lvalue != 0L) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addLong(lvalue);
                    return true;
                }
                return false;
            }
            case DOUBLE: {
                double dvalue = fieldAccess.getDouble(parent);
                if (dvalue != 0.0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addDouble(dvalue);
                    return true;
                }
                return false;
            }
            case FLOAT: {
                float fvalue = fieldAccess.getFloat(parent);
                if (fvalue != 0.0f) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addFloat(fvalue);
                    return true;
                }
                return false;
            }
            case SHORT: {
                short svalue = fieldAccess.getShort(parent);
                if (svalue != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addShort(svalue);
                    return true;
                }
                return false;
            }
            case CHAR: {
                char cvalue = fieldAccess.getChar(parent);
                if (cvalue != '\u0000') {
                    this.serializeFieldName(fieldName, builder);
                    builder.addQuoted("" + cvalue);
                    return true;
                }
                return false;
            }
        }
        Object value = fieldAccess.getObject(parent);
        if (value == null) {
            return false;
        }
        if (value == parent) {
            return false;
        }
        switch (typeEnum) {
            case BIG_DECIMAL: {
                this.serializeFieldName(fieldName, builder);
                builder.addBigDecimal((BigDecimal)value);
                return true;
            }
            case NUMBER: {
                Number nvalue = (Number)fieldAccess.getObject(parent);
                if (nvalue.intValue() != 0) {
                    this.serializeFieldName(fieldName, builder);
                    builder.addString(nvalue.toString());
                    return true;
                }
                return false;
            }
            case BIG_INT: {
                this.serializeFieldName(fieldName, builder);
                builder.addBigInteger((BigInteger)value);
                return true;
            }
            case DATE: {
                this.serializeFieldName(fieldName, builder);
                this.serializeDate((Date)value, builder);
                return true;
            }
            case STRING: {
                this.serializeFieldName(fieldName, builder);
                this.serializeString((String)value, builder);
                return true;
            }
            case CLASS: {
                this.serializeFieldName(fieldName, builder);
                builder.addQuoted(((Class)value).getName());
                return true;
            }
            case CHAR_SEQUENCE: {
                this.serializeFieldName(fieldName, builder);
                this.serializeString(value.toString(), builder);
                return true;
            }
            case INTEGER_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addInt((Integer)value);
                return true;
            }
            case BOOLEAN_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addBoolean((Boolean)value);
                return true;
            }
            case LONG_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addLong((Long)value);
                return true;
            }
            case FLOAT_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addFloat((Float)value);
                return true;
            }
            case DOUBLE_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addDouble((Double)value);
                return true;
            }
            case SHORT_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addShort((Short)value);
                return true;
            }
            case BYTE_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addByte((Byte)value);
                return true;
            }
            case CHAR_WRAPPER: {
                this.serializeFieldName(fieldName, builder);
                builder.addQuoted(((Character)value).toString());
                return true;
            }
            case ENUM: {
                this.serializeFieldName(fieldName, builder);
                builder.addQuoted(value.toString());
                return true;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                Collection collection = (Collection)value;
                if (collection.size() > 0) {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeCollection(collection, builder);
                    return true;
                }
                return false;
            }
            case MAP: {
                Map map = (Map)value;
                if (map.size() > 0) {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeMap(map, builder);
                    return true;
                }
                return false;
            }
            case ARRAY: 
            case ARRAY_INT: 
            case ARRAY_BYTE: 
            case ARRAY_SHORT: 
            case ARRAY_FLOAT: 
            case ARRAY_DOUBLE: 
            case ARRAY_LONG: 
            case ARRAY_STRING: 
            case ARRAY_OBJECT: {
                if (value.getClass().isArray() && Array.getLength(value) > 0) {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeArray(fieldAccess.componentType(), value, builder);
                    return true;
                }
                return false;
            }
            case INTERFACE: 
            case ABSTRACT: {
                this.serializeFieldName(fieldName, builder);
                this.serializeSubtypeInstance(value, builder);
                return true;
            }
            case OBJECT: {
                this.serializeFieldName(fieldName, builder);
                TypeType instanceType = TypeType.getInstanceType(value);
                if (instanceType == TypeType.INSTANCE) {
                    this.serializeSubtypeInstance(value, builder);
                } else {
                    this.serializeObject(value, builder);
                }
                return true;
            }
            case INSTANCE: {
                this.serializeFieldName(fieldName, builder);
                this.serializeInstance(value, builder);
                return true;
            }
            case SYSTEM: {
                return false;
            }
            case TIME_ZONE: {
                this.serializeFieldName(fieldName, builder);
                TimeZone zone = (TimeZone)value;
                builder.addQuoted(zone.getID());
                return true;
            }
            case CURRENCY: {
                this.serializeFieldName(fieldName, builder);
                this.serializeCurrency((Currency)value, builder);
                return true;
            }
        }
        this.serializeFieldName(fieldName, builder);
        this.serializeUnknown(value, builder);
        return true;
    }

    @Override
    public final void serializeDate(Date date, CharBuf builder) {
        builder.addLong(date.getTime());
    }

    public final void serializeCurrency(Currency currency, CharBuf builder) {
        builder.addChar('\"');
        builder.addString(currency.getCurrencyCode());
        builder.addChar('\"');
    }

    @Override
    public final void serializeObject(Object obj, CharBuf builder) {
        TypeType type = TypeType.getInstanceType(obj);
        switch (type) {
            case NULL: {
                builder.addNull();
                return;
            }
            case INT: {
                builder.addInt(Integer.TYPE.cast(obj));
                return;
            }
            case BOOLEAN: {
                builder.addBoolean(Boolean.TYPE.cast(obj));
                return;
            }
            case BYTE: {
                builder.addByte(Byte.TYPE.cast(obj));
                return;
            }
            case LONG: {
                builder.addLong(Long.TYPE.cast(obj));
                return;
            }
            case DOUBLE: {
                builder.addDouble(Double.TYPE.cast(obj));
                return;
            }
            case FLOAT: {
                builder.addFloat(Float.TYPE.cast(obj));
                return;
            }
            case SHORT: {
                builder.addShort(Short.TYPE.cast(obj));
                return;
            }
            case CHAR: {
                builder.addChar(Character.TYPE.cast(obj).charValue());
                return;
            }
            case BIG_DECIMAL: {
                builder.addBigDecimal((BigDecimal)obj);
                return;
            }
            case BIG_INT: {
                builder.addBigInteger((BigInteger)obj);
                return;
            }
            case DATE: {
                this.serializeDate((Date)obj, builder);
                return;
            }
            case CLASS: {
                builder.addQuoted(((Class)obj).getName());
                return;
            }
            case STRING: {
                this.serializeString((String)obj, builder);
                return;
            }
            case CHAR_SEQUENCE: {
                this.serializeString(obj.toString(), builder);
                return;
            }
            case BOOLEAN_WRAPPER: {
                builder.addBoolean((Boolean)obj);
                return;
            }
            case INTEGER_WRAPPER: {
                builder.addInt((Integer)obj);
                return;
            }
            case LONG_WRAPPER: {
                builder.addLong((Long)obj);
                return;
            }
            case FLOAT_WRAPPER: {
                builder.addFloat((Float)obj);
                return;
            }
            case DOUBLE_WRAPPER: {
                builder.addDouble((Double)obj);
                return;
            }
            case SHORT_WRAPPER: {
                builder.addShort((Short)obj);
                return;
            }
            case BYTE_WRAPPER: {
                builder.addByte((Byte)obj);
                return;
            }
            case CHAR_WRAPPER: {
                builder.addChar(((Character)obj).charValue());
                return;
            }
            case ENUM: {
                builder.addQuoted(obj.toString());
                return;
            }
            case TIME_ZONE: {
                TimeZone zone = (TimeZone)obj;
                builder.addQuoted(zone.getID());
                return;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                this.serializeCollection((Collection)obj, builder);
                return;
            }
            case MAP: {
                this.serializeMap((Map)obj, builder);
                return;
            }
            case ARRAY: 
            case ARRAY_INT: 
            case ARRAY_BYTE: 
            case ARRAY_SHORT: 
            case ARRAY_FLOAT: 
            case ARRAY_DOUBLE: 
            case ARRAY_LONG: 
            case ARRAY_STRING: 
            case ARRAY_OBJECT: {
                this.serializeArray(obj, builder);
                return;
            }
            case INTERFACE: 
            case ABSTRACT: {
                this.serializeSubtypeInstance(obj, builder);
                return;
            }
            case VALUE: {
                Value value = (Value)obj;
                this.serializeObject(value.toValue(), builder);
                return;
            }
            case INSTANCE: {
                this.serializeInstance(obj, builder);
                return;
            }
            case CURRENCY: {
                this.serializeCurrency((Currency)obj, builder);
                return;
            }
        }
        this.serializeUnknown(obj, builder);
    }

    @Override
    public void serializeUnknown(Object obj, CharBuf builder) {
        builder.addQuoted(obj.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void serializeInstance(Object instance, CharBuf builder) {
        try {
            ++this.level;
            if (this.level > 100) {
                Exceptions.die("Detected circular dependency", builder.toString());
            }
            if (this.serializeAsSupport && Reflection.respondsTo(instance, "serializeAs")) {
                this.serializeObject(Invoker.invoke(instance, "serializeAs", new Object[0]), builder);
                return;
            }
            Collection<FieldAccess> fields = this.getFields(instance.getClass()).values();
            builder.addChar('{');
            int index = 0;
            for (FieldAccess fieldAccess : fields) {
                if (!this.serializeField(instance, fieldAccess, builder)) continue;
                builder.add(',');
                ++index;
            }
            if (index > 0) {
                builder.removeLastChar();
            }
            builder.addChar('}');
        }
        catch (Exception ex) {
            Exceptions.handle(ex, "serialize instance", instance, "class name of instance", Boon.className(instance), "obj", instance);
        }
        finally {
            --this.level;
        }
    }

    @Override
    public void serializeInstance(Object obj, CharBuf builder, boolean includeTypeInfo) {
        this.serializeInstance(obj, builder);
    }

    @Override
    public Map<String, FieldAccess> getFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> map = this.fieldMap.get(aClass);
        if (map == null) {
            map = this.doGetFields(aClass);
            this.fieldMap.put(aClass, map);
        }
        return map;
    }

    private final Map<String, FieldAccess> doGetFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> fields = Maps.copy(Reflection.getPropertyFieldAccessMapFieldFirstForSerializer(aClass));
        ArrayList<FieldAccess> removeFields = new ArrayList<FieldAccess>();
        for (FieldAccess field : fields.values()) {
            if (!field.isWriteOnly()) continue;
            removeFields.add(field);
        }
        for (FieldAccess fieldAccess : removeFields) {
            fields.remove(fieldAccess.name());
        }
        return fields;
    }

    @Override
    public final void serializeMap(Map<Object, Object> smap, CharBuf builder) {
        Map<Object, Object> map = smap;
        if (map.size() == 0) {
            builder.addChars(EMPTY_MAP_CHARS);
            return;
        }
        builder.addChar('{');
        int index = 0;
        Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (entry.getValue() == null) continue;
            this.serializeFieldName(Str.toString(entry.getKey()), builder);
            this.serializeObject(entry.getValue(), builder);
            builder.addChar(',');
            ++index;
        }
        if (index > 0) {
            builder.removeLastChar();
        }
        builder.addChar('}');
    }

    public final void serializeArray(TypeType componentType, Object objectArray, CharBuf builder) {
        switch (componentType) {
            case STRING: {
                String[] array = (String[])objectArray;
                int length = array.length;
                builder.addChar('[');
                for (int index = 0; index < length; ++index) {
                    this.serializeString(array[index], builder);
                    builder.addChar(',');
                }
                builder.removeLastChar();
                builder.addChar(']');
                break;
            }
            default: {
                this.serializeArray(objectArray, builder);
            }
        }
    }

    @Override
    public final void serializeArray(Object array, CharBuf builder) {
        if (Array.getLength(array) == 0) {
            builder.addChars(EMPTY_LIST_CHARS);
            return;
        }
        builder.addChar('[');
        int length = Array.getLength(array);
        for (int index = 0; index < length; ++index) {
            Object o = Array.get(array, index);
            if (o == null) {
                builder.addNull();
                builder.addChar(',');
                continue;
            }
            this.serializeObject(Array.get(array, index), builder);
            builder.addChar(',');
        }
        builder.removeLastChar();
        builder.addChar(']');
    }

    private void serializeFieldName(String name, CharBuf builder) {
        builder.addJsonFieldName(FastStringUtils.toCharArray(name));
    }

    @Override
    public final void serializeCollection(Collection<?> collection, CharBuf builder) {
        if (collection.size() == 0) {
            builder.addChars(EMPTY_LIST_CHARS);
            return;
        }
        builder.addChar('[');
        for (Object o : collection) {
            if (o == null) {
                builder.addNull();
            } else {
                this.serializeObject(o, builder);
            }
            builder.addChar(',');
        }
        builder.removeLastChar();
        builder.addChar(']');
    }

    @Override
    public void serializeSubtypeInstance(Object instance, CharBuf builder) {
        ++this.level;
        if (this.level > 100) {
            Exceptions.die("Detected circular dependency", builder.toString());
        }
        Map<String, FieldAccess> fieldAccessors = this.getFields(instance.getClass());
        Collection<FieldAccess> values = fieldAccessors.values();
        builder.addString("{\"class\":");
        builder.addQuoted(instance.getClass().getName());
        int index = 0;
        int length = values.size();
        if (length > 0) {
            builder.addChar(',');
            for (FieldAccess fieldAccess : values) {
                if (!this.serializeField(instance, fieldAccess, builder)) continue;
                builder.addChar(',');
                ++index;
            }
            if (index > 0) {
                builder.removeLastChar();
            }
            builder.addChar('}');
        }
        --this.level;
    }
}

