/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.validators;

import org.boon.messages.MessageSpecification;
import org.boon.validation.ValidatorMessage;
import org.boon.validation.ValidatorMessageHolder;
import org.boon.validation.validators.AbstractRangeValidator;

public class LongRangeValidator
extends AbstractRangeValidator {
    private Long min;
    private Long max;
    private Class<?> type;
    private MessageSpecification underMin;
    private MessageSpecification overMax;

    @Override
    public ValidatorMessageHolder validate(Object fieldValue, String fieldLabel) {
        ValidatorMessage validatorMessage = new ValidatorMessage();
        if (fieldValue == null) {
            return validatorMessage;
        }
        this.dynamicallyInitIfNeeded(fieldValue);
        if (!super.isValueGreaterThanMin((Comparable)fieldValue)) {
            this.populateMessage(this.underMin, validatorMessage, fieldLabel, this.min);
        } else if (!super.isValueLessThanMax((Comparable)fieldValue)) {
            this.populateMessage(this.overMax, validatorMessage, fieldLabel, this.max);
        }
        return validatorMessage;
    }

    @Override
    public void init() {
        if (this.underMin == null) {
            this.underMin = new MessageSpecification();
            this.underMin.setDetailMessage("{validator.range.underMin.detail}");
            this.underMin.setSummaryMessage("{validator.range.underMin.summary}");
        }
        if (this.overMax == null) {
            this.overMax = new MessageSpecification();
            this.overMax.setDetailMessage("{validator.range.overMax.detail}");
            this.overMax.setSummaryMessage("{validator.range.overMax.summary");
        }
        if (this.type == null) {
            return;
        }
        if (!this.isInitialized()) {
            if (this.type.equals(Integer.class)) {
                this.init(new Integer(this.min.intValue()), new Integer(this.max.intValue()));
            } else if (this.type.equals(Byte.class)) {
                this.init(new Byte(this.min.byteValue()), new Byte(this.max.byteValue()));
            } else if (this.type.equals(Short.class)) {
                this.init(new Short(this.min.byteValue()), new Short(this.max.byteValue()));
            } else {
                this.init(this.min, this.max);
            }
        }
    }

    private void dynamicallyInitIfNeeded(Object value) {
        if (!this.isInitialized()) {
            if (value instanceof Integer) {
                this.init(new Integer(this.min.intValue()), new Integer(this.max.intValue()));
            } else if (value instanceof Byte) {
                this.init(new Byte(this.min.byteValue()), new Byte(this.max.byteValue()));
            } else if (value instanceof Short) {
                this.init(new Short(this.min.shortValue()), new Short(this.max.shortValue()));
            } else {
                this.init(this.min, this.max);
            }
        }
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    protected void setOverMax(MessageSpecification overMax) {
        this.overMax = overMax;
    }

    protected void setUnderMin(MessageSpecification underMin) {
        this.underMin = underMin;
    }
}

