/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxUser;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.text.ParseException;
import java.util.Date;

public class BoxEvent
extends BoxResource {
    private BoxResource.Info sourceInfo;
    private Type type;
    private JsonObject sourceJSON;
    private Date createdAt;
    private String ipAddress;
    private JsonObject additionalDetails;
    private BoxCollaborator.Info accessibleBy;
    private BoxUser.Info createdBy;
    private String sessionID;

    public BoxEvent(BoxAPIConnection api, String json) {
        this(api, JsonObject.readFrom(json));
    }

    BoxEvent(BoxAPIConnection api, JsonObject jsonObject) {
        super(api, jsonObject.get("event_id").asString());
        for (JsonObject.Member member : jsonObject) {
            if (member.getValue().isNull()) continue;
            this.parseJsonMember(member);
        }
    }

    public BoxResource.Info getSourceInfo() {
        return this.sourceInfo;
    }

    public JsonObject getSourceJSON() {
        return this.sourceJSON;
    }

    public Type getType() {
        return this.type;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public JsonObject getAdditionalDetails() {
        return this.additionalDetails;
    }

    public BoxCollaborator.Info getAccessibleBy() {
        return this.accessibleBy;
    }

    public BoxUser.Info getCreatedBy() {
        return this.createdBy;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    void parseJsonMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        if (value.isNull()) {
            return;
        }
        String memberName = member.getName();
        if (memberName.equals("source")) {
            try {
                this.sourceInfo = BoxResource.parseInfo(this.getAPI(), value.asObject());
            }
            catch (Exception e) {
                this.sourceInfo = null;
            }
            this.sourceJSON = JsonObject.unmodifiableObject(value.asObject());
        } else if (memberName.equals("event_type")) {
            String stringValue = value.asString();
            for (Type t : Type.values()) {
                if (!t.name().equals(stringValue)) continue;
                this.type = t;
                break;
            }
            if (this.type == null) {
                this.type = Type.UNKNOWN;
            }
        } else if (memberName.equals("created_at")) {
            try {
                this.createdAt = BoxDateFormat.parse(value.asString());
            }
            catch (ParseException e) {
                assert (false) : "A ParseException indicates a bug in the SDK.";
            }
        } else if (memberName.equals("ip_address")) {
            this.ipAddress = value.asString();
        } else if (memberName.equals("additional_details")) {
            this.additionalDetails = value.asObject();
        } else if (memberName.equals("accessible_by")) {
            this.accessibleBy = (BoxCollaborator.Info)BoxResource.parseInfo(this.getAPI(), value.asObject());
        } else if (memberName.equals("created_by")) {
            this.createdBy = (BoxUser.Info)BoxResource.parseInfo(this.getAPI(), value.asObject());
        } else if (memberName.equals("session_id")) {
            this.sessionID = value.asString();
        }
    }

    public static enum Type {
        UNKNOWN,
        ITEM_CREATE,
        ITEM_UPLOAD,
        COMMENT_CREATE,
        ITEM_DOWNLOAD,
        ITEM_PREVIEW,
        ITEM_MOVE,
        ITEM_COPY,
        TASK_ASSIGNMENT_CREATE,
        LOCK_CREATE,
        LOCK_DESTROY,
        ITEM_TRASH,
        ITEM_UNDELETE_VIA_TRASH,
        COLLAB_ADD_COLLABORATOR,
        COLLAB_REMOVE_COLLABORATOR,
        COLLAB_INVITE_COLLABORATOR,
        COLLAB_ROLE_CHANGE,
        ITEM_SYNC,
        ITEM_UNSYNC,
        ITEM_RENAME,
        ITEM_SHARED_CREATE,
        ITEM_SHARED_UNSHARE,
        ITEM_SHARED,
        TAG_ITEM_CREATE,
        ADD_LOGIN_ACTIVITY_DEVICE,
        REMOVE_LOGIN_ACTIVITY_DEVICE,
        CHANGE_ADMIN_ROLE,
        GROUP_ADD_USER,
        NEW_USER,
        GROUP_CREATION,
        GROUP_DELETION,
        DELETE_USER,
        GROUP_EDITED,
        EDIT_USER,
        GROUP_ADD_FOLDER,
        GROUP_REMOVE_USER,
        GROUP_REMOVE_FOLDER,
        ADMIN_LOGIN,
        ADD_DEVICE_ASSOCIATION,
        FAILED_LOGIN,
        LOGIN,
        USER_AUTHENTICATE_OAUTH2_TOKEN_REFRESH,
        REMOVE_DEVICE_ASSOCIATION,
        TERMS_OF_SERVICE_AGREE,
        TERMS_OF_SERVICE_REJECT,
        COPY,
        DELETE,
        DOWNLOAD,
        EDIT,
        LOCK,
        MOVE,
        PREVIEW,
        RENAME,
        STORAGE_EXPIRATION,
        UNDELETE,
        UNLOCK,
        UPLOAD,
        SHARE,
        ITEM_SHARED_UPDATE,
        UPDATE_SHARE_EXPIRATION,
        SHARE_EXPIRATION,
        UNSHARE,
        COLLABORATION_ACCEPT,
        COLLABORATION_ROLE_CHANGE,
        UPDATE_COLLABORATION_EXPIRATION,
        COLLABORATION_REMOVE,
        COLLABORATION_INVITE,
        COLLABORATION_EXPIRATION;

    }
}

