/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxGroupIterator;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class BoxGroup
extends BoxCollaborator {
    private static final URLTemplate GROUPS_URL_TEMPLATE = new URLTemplate("groups");
    private static final URLTemplate GROUP_URL_TEMPLATE = new URLTemplate("groups/%s");
    private static final URLTemplate MEMBERSHIPS_URL_TEMPLATE = new URLTemplate("groups/%s/memberships");
    private static final URLTemplate ADD_MEMBERSHIP_URL_TEMPLATE = new URLTemplate("group_memberships");

    public BoxGroup(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createGroup(BoxAPIConnection api, String name) {
        BoxGroup group;
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("name", name);
        URL url = GROUPS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxGroup boxGroup = group = new BoxGroup(api, responseJSON.get("id").asString());
        boxGroup.getClass();
        return boxGroup.new Info(responseJSON);
    }

    public static Iterable<Info> getAllGroups(final BoxAPIConnection api) {
        return new Iterable<Info>(){

            @Override
            public Iterator<Info> iterator() {
                URL url = GROUPS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
                return new BoxGroupIterator(api, url);
            }
        };
    }

    public Info getInfo() {
        URL url = GROUP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        return new Info(responseJSON);
    }

    public Collection<BoxGroupMembership.Info> getMemberships() {
        BoxAPIConnection api = this.getAPI();
        URL url = MEMBERSHIPS_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxGroupMembership.Info> memberships = new ArrayList<BoxGroupMembership.Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxGroupMembership membership;
            JsonObject entryObject = entry.asObject();
            BoxGroupMembership boxGroupMembership = membership = new BoxGroupMembership(api, entryObject.get("id").asString());
            boxGroupMembership.getClass();
            BoxGroupMembership.Info info = new BoxGroupMembership.Info(boxGroupMembership, entryObject);
            memberships.add(info);
        }
        return memberships;
    }

    public BoxGroupMembership.Info addMembership(BoxUser user) {
        return this.addMembership(user, null);
    }

    public BoxGroupMembership.Info addMembership(BoxUser user, BoxGroupMembership.Role role) {
        BoxGroupMembership membership;
        BoxAPIConnection api = this.getAPI();
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("user", new JsonObject().add("id", user.getID()));
        requestJSON.add("group", new JsonObject().add("id", this.getID()));
        if (role != null) {
            requestJSON.add("role", role.toJSONString());
        }
        URL url = ADD_MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxGroupMembership boxGroupMembership = membership = new BoxGroupMembership(api, responseJSON.get("id").asString());
        boxGroupMembership.getClass();
        return new BoxGroupMembership.Info(boxGroupMembership, responseJSON);
    }

    public void delete() {
        URL url = GROUP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxCollaborator.Info {
        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxGroup getResource() {
            return BoxGroup.this;
        }
    }
}

