/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

public class BoxGroupMembership
extends BoxResource {
    private static final URLTemplate MEMBERSHIP_URL_TEMPLATE = new URLTemplate("group_memberships/%s");

    public BoxGroupMembership(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public Info getInfo() {
        BoxAPIConnection api = this.getAPI();
        URL url = MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        return new Info(jsonObject);
    }

    public void updateInfo(Info info) {
        BoxAPIConnection api = this.getAPI();
        URL url = MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(api, url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        info.update(jsonObject);
    }

    public void delete() {
        BoxAPIConnection api = this.getAPI();
        URL url = MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public static enum Role {
        ADMIN("admin"),
        MEMBER("member");

        private final String jsonValue;

        private Role(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Role fromJSONString(String jsonValue) {
            return Role.valueOf(jsonValue.toUpperCase());
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }

    public class Info
    extends BoxResource.Info {
        private BoxUser.Info user;
        private BoxGroup.Info group;
        private Role role;
        private Date createdAt;
        private Date modifiedAt;

        public Info() {
            super(BoxGroupMembership.this);
        }

        public Info(String json) {
            super((BoxResource)BoxGroupMembership.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxGroupMembership.this, jsonObject);
        }

        public BoxUser.Info getUser() {
            return this.user;
        }

        public BoxGroup.Info getGroup() {
            return this.group;
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
            this.addPendingChange("role", role.toJSONString());
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        public BoxGroupMembership getResource() {
            return BoxGroupMembership.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            block15: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("user")) {
                        JsonObject userJSON = value.asObject();
                        if (this.user == null) {
                            BoxUser user;
                            String userID = userJSON.get("id").asString();
                            BoxUser boxUser = user = new BoxUser(BoxGroupMembership.this.getAPI(), userID);
                            boxUser.getClass();
                            this.user = new BoxUser.Info(boxUser, userJSON);
                        } else {
                            this.user.update(userJSON);
                        }
                    } else if (memberName.equals("group")) {
                        JsonObject groupJSON = value.asObject();
                        if (this.group == null) {
                            BoxGroup group;
                            String userID = groupJSON.get("id").asString();
                            BoxGroup boxGroup = group = new BoxGroup(BoxGroupMembership.this.getAPI(), userID);
                            boxGroup.getClass();
                            this.group = boxGroup.new BoxGroup.Info(groupJSON);
                        } else {
                            this.group.update(groupJSON);
                        }
                    } else if (memberName.equals("role")) {
                        this.role = Role.fromJSONString(value.asString());
                    } else if (memberName.equals("created_at")) {
                        this.createdAt = BoxDateFormat.parse(value.asString());
                    } else if (memberName.equals("modified_at")) {
                        this.modifiedAt = BoxDateFormat.parse(value.asString());
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }
    }
}

