/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;

@JsxClass(domClass=DomDocumentType.class)
public class DocumentType
extends Node {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public DocumentType() {
    }

    @JsxGetter
    public String getName() {
        return ((DomDocumentType)this.getDomNodeOrDie()).getName();
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @JsxGetter
    public String getPublicId() {
        return ((DomDocumentType)this.getDomNodeOrDie()).getPublicId();
    }

    @JsxGetter
    public String getSystemId() {
        return ((DomDocumentType)this.getDomNodeOrDie()).getSystemId();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=38), @WebBrowser(value=BrowserName.IE)})
    public String getInternalSubset() {
        String subset = ((DomDocumentType)this.getDomNodeOrDie()).getInternalSubset();
        if (StringUtils.isNotEmpty(subset)) {
            return subset;
        }
        return null;
    }

    @JsxGetter
    public Object getEntities() {
        NamedNodeMap entities = ((DomDocumentType)this.getDomNodeOrDie()).getEntities();
        if (null != entities) {
            return entities;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCTYPE_ENTITIES_NULL)) {
            return null;
        }
        return Undefined.instance;
    }

    @JsxGetter
    public Object getNotations() {
        NamedNodeMap notations = ((DomDocumentType)this.getDomNodeOrDie()).getNotations();
        if (null != notations) {
            return notations;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCTYPE_NOTATIONS_NULL)) {
            return null;
        }
        return Undefined.instance;
    }

    @Override
    public Object getPrefix() {
        Object prefix = super.getPrefix();
        if (prefix == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.DOCTYPE_PREFIX_UNDEFINED)) {
            return Undefined.instance;
        }
        return prefix;
    }

    @Override
    public Object getLocalName() {
        Object localName = super.getLocalName();
        if (localName == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.DOCTYPE_PREFIX_UNDEFINED)) {
            return Undefined.instance;
        }
        return localName;
    }

    @Override
    public Object getNamespaceURI() {
        Object namespaceURI = super.getNamespaceURI();
        if (namespaceURI == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.DOCTYPE_PREFIX_UNDEFINED)) {
            return Undefined.instance;
        }
        return namespaceURI;
    }
}

