/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxUser;
import com.box.sdk.CreateUserParams;
import com.box.sdk.EmailAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxUsersManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxUsersManager.class);
    private BoxAPIConnection boxConnection;

    public BoxUsersManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public BoxUser getCurrentUser() {
        try {
            LOG.debug("Getting current user");
            return BoxUser.getCurrentUser(this.boxConnection);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public List<BoxUser.Info> getAllEnterpriseOrExternalUsers(String filterTerm, String ... fields) {
        try {
            LOG.debug("Getting all enterprise users matching filterTerm=" + filterTerm);
            ArrayList<BoxUser.Info> users = new ArrayList<BoxUser.Info>();
            Iterable<BoxUser.Info> iterable = filterTerm == null ? BoxUser.getAllEnterpriseUsers(this.boxConnection) : BoxUser.getAllEnterpriseUsers(this.boxConnection, filterTerm, fields);
            for (BoxUser.Info info : iterable) {
                users.add(info);
            }
            return users;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxUser createEnterpriseUser(String login, String name, CreateUserParams params) {
        try {
            LOG.debug("Creating enterprise user with login=" + login + " name=" + name);
            if (login == null) {
                throw new IllegalArgumentException("Parameter 'login' can not be null");
            }
            if (name == null) {
                throw new IllegalArgumentException("Parameter 'name' can not be null");
            }
            if (params != null) {
                return BoxUser.createEnterpriseUser(this.boxConnection, login, name, params).getResource();
            }
            return BoxUser.createEnterpriseUser(this.boxConnection, login, name).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxUser createAppUser(String name, CreateUserParams params) {
        try {
            LOG.debug("Creating app user with name=" + name);
            if (name == null) {
                throw new IllegalArgumentException("Parameter 'name' can not be null");
            }
            if (params != null) {
                return BoxUser.createAppUser(this.boxConnection, name, params).getResource();
            }
            return BoxUser.createAppUser(this.boxConnection, name).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxUser.Info getUserInfo(String userId) {
        try {
            LOG.debug("Getting info for user(id=" + userId + ")");
            if (userId == null) {
                throw new IllegalArgumentException("Parameter 'userId' can not be null");
            }
            BoxUser user = new BoxUser(this.boxConnection, userId);
            return user.getInfo(new String[0]);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxUser updateUserInfo(String userId, BoxUser.Info info) {
        try {
            LOG.debug("Updating info for user(id=" + userId + ")");
            if (userId == null) {
                throw new IllegalArgumentException("Parameter 'userId' can not be null");
            }
            if (info == null) {
                throw new IllegalArgumentException("Parameter 'info' can not be null");
            }
            BoxUser user = new BoxUser(this.boxConnection, userId);
            user.updateInfo(info);
            return user;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteUser(String userId, boolean notifyUser, boolean force) {
        try {
            LOG.debug("Deleting user(id=" + userId + ") notifyUser=" + notifyUser + " force=" + force);
            if (userId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxUser file = new BoxUser(this.boxConnection, userId);
            file.delete(notifyUser, force);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public EmailAlias addUserEmailAlias(String userId, String email) {
        try {
            LOG.debug("Adding email alias '" + email + "' to user(id=" + userId + ")");
            if (userId == null) {
                throw new IllegalArgumentException("Parameter 'userId' can not be null");
            }
            if (email == null) {
                throw new IllegalArgumentException("Paramerer 'email' can not be null");
            }
            BoxUser user = new BoxUser(this.boxConnection, userId);
            return user.addEmailAlias(email);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Collection<EmailAlias> getUserEmailAlias(String userId) {
        try {
            LOG.debug("Get email aliases for user(id=" + userId + ")");
            if (userId == null) {
                throw new IllegalArgumentException("Parameter 'userId' can not be null");
            }
            BoxUser user = new BoxUser(this.boxConnection, userId);
            return user.getEmailAliases();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteUserEmailAlias(String userId, String emailAliasId) {
        try {
            LOG.debug("Deleting email_alias(" + emailAliasId + ") for user(id=" + userId + ")");
            if (userId == null) {
                throw new IllegalArgumentException("Parameter 'userId' can not be null");
            }
            if (emailAliasId == null) {
                throw new IllegalArgumentException("Parameter 'emailAliasId' can not be null");
            }
            BoxUser user = new BoxUser(this.boxConnection, userId);
            user.deleteEmailAlias(emailAliasId);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

