/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxRetentionPolicyAssignment;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

@BoxResourceType(value="retention_policy")
public class BoxRetentionPolicy
extends BoxResource {
    public static final URLTemplate RETENTION_POLICIES_URL_TEMPLATE = new URLTemplate("retention_policies");
    public static final URLTemplate POLICY_URL_TEMPLATE = new URLTemplate("retention_policies/%s");
    public static final URLTemplate ASSIGNMENTS_URL_TEMPLATE = new URLTemplate("retention_policies/%s/assignments");
    public static final String ACTION_PERMANENTLY_DELETE = "permanently_delete";
    public static final String ACTION_REMOVE_RETENTION = "remove_retention";
    public static final String STATUS_ACTIVE = "active";
    public static final String STATUS_RETIRED = "retired";
    private static final String TYPE_FINITE = "finite";
    private static final String TYPE_INDEFINITE = "indefinite";
    private static final int DEFAULT_LIMIT = 100;

    public BoxRetentionPolicy(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createIndefinitePolicy(BoxAPIConnection api, String name) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, TYPE_INDEFINITE, 0, ACTION_REMOVE_RETENTION);
    }

    public static Info createFinitePolicy(BoxAPIConnection api, String name, int length, String action) {
        return BoxRetentionPolicy.createRetentionPolicy(api, name, TYPE_FINITE, length, action);
    }

    private static Info createRetentionPolicy(BoxAPIConnection api, String name, String type, int length, String action) {
        BoxRetentionPolicy createdPolicy;
        URL url = RETENTION_POLICIES_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("policy_name", name).add("policy_type", type).add("disposition_action", action);
        if (!type.equals(TYPE_INDEFINITE)) {
            requestJSON.add("retention_length", length);
        }
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxRetentionPolicy boxRetentionPolicy = createdPolicy = new BoxRetentionPolicy(api, responseJSON.get("id").asString());
        boxRetentionPolicy.getClass();
        return boxRetentionPolicy.new Info(responseJSON);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getFolderAssignments(String ... fields) {
        return this.getFolderAssignments(100, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getFolderAssignments(int limit, String ... fields) {
        return this.getAssignments("folder", limit, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getEnterpriseAssignments(String ... fields) {
        return this.getEnterpriseAssignments(100, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getEnterpriseAssignments(int limit, String ... fields) {
        return this.getAssignments("enterprise", limit, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getAllAssignments(String ... fields) {
        return this.getAllAssignments(100, fields);
    }

    public Iterable<BoxRetentionPolicyAssignment.Info> getAllAssignments(int limit, String ... fields) {
        return this.getAssignments(null, limit, fields);
    }

    private Iterable<BoxRetentionPolicyAssignment.Info> getAssignments(String type, int limit, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (type != null) {
            queryString.appendParam("type", type);
        }
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = ASSIGNMENTS_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString.toString(), this.getID());
        return new BoxResourceIterable<BoxRetentionPolicyAssignment.Info>(this.getAPI(), url, limit){

            @Override
            protected BoxRetentionPolicyAssignment.Info factory(JsonObject jsonObject) {
                BoxRetentionPolicyAssignment assignment;
                BoxRetentionPolicyAssignment boxRetentionPolicyAssignment = assignment = new BoxRetentionPolicyAssignment(BoxRetentionPolicy.this.getAPI(), jsonObject.get("id").asString());
                boxRetentionPolicyAssignment.getClass();
                return new BoxRetentionPolicyAssignment.Info(boxRetentionPolicyAssignment, jsonObject);
            }
        };
    }

    public BoxRetentionPolicyAssignment.Info assignTo(BoxFolder folder) {
        return BoxRetentionPolicyAssignment.createAssignmentToFolder(this.getAPI(), this.getID(), folder.getID());
    }

    public BoxRetentionPolicyAssignment.Info assignToEnterprise() {
        return BoxRetentionPolicyAssignment.createAssignmentToEnterprise(this.getAPI(), this.getID());
    }

    public void updateInfo(Info info) {
        URL url = POLICY_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        info.update(responseJSON);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = POLICY_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        return new Info(responseJSON);
    }

    public static Iterable<Info> getAll(BoxAPIConnection api, String ... fields) {
        return BoxRetentionPolicy.getAll(null, null, null, 100, api, fields);
    }

    public static Iterable<Info> getAll(String name, String type, String userID, int limit, final BoxAPIConnection api, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (name != null) {
            queryString.appendParam("policy_name", name);
        }
        if (type != null) {
            queryString.appendParam("policy_type", type);
        }
        if (userID != null) {
            queryString.appendParam("created_by_user_id", userID);
        }
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = RETENTION_POLICIES_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), queryString.toString(), new Object[0]);
        return new BoxResourceIterable<Info>(api, url, limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxRetentionPolicy policy;
                BoxRetentionPolicy boxRetentionPolicy = policy = new BoxRetentionPolicy(api, jsonObject.get("id").asString());
                boxRetentionPolicy.getClass();
                return boxRetentionPolicy.new Info(jsonObject);
            }
        };
    }

    public class Info
    extends BoxResource.Info {
        private String policyName;
        private String policyType;
        private int retentionLength;
        private String dispositionAction;
        private String status;
        private BoxUser.Info createdBy;
        private Date createdAt;
        private Date modifiedAt;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxRetentionPolicy.this;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public String getPolicyType() {
            return this.policyType;
        }

        public int getRetentionLength() {
            return this.retentionLength;
        }

        public String getDispositionAction() {
            return this.dispositionAction;
        }

        public String getStatus() {
            return this.status;
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            block19: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("policy_name")) {
                        this.policyName = value.asString();
                    } else if (memberName.equals("policy_type")) {
                        this.policyType = value.asString();
                    } else if (memberName.equals("retention_length")) {
                        this.retentionLength = value.asInt();
                    } else if (memberName.equals("disposition_action")) {
                        this.dispositionAction = value.asString();
                    } else if (memberName.equals("status")) {
                        this.status = value.asString();
                    } else if (memberName.equals("created_by")) {
                        JsonObject userJSON = value.asObject();
                        if (this.createdBy == null) {
                            BoxUser user;
                            String userID = userJSON.get("id").asString();
                            BoxUser boxUser = user = new BoxUser(BoxRetentionPolicy.this.getAPI(), userID);
                            boxUser.getClass();
                            this.createdBy = new BoxUser.Info(boxUser, userJSON);
                        } else {
                            this.createdBy.update(userJSON);
                        }
                    } else if (memberName.equals("created_at")) {
                        this.createdAt = BoxDateFormat.parse(value.asString());
                    } else if (memberName.equals("modified_at")) {
                        this.modifiedAt = BoxDateFormat.parse(value.asString());
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }
    }
}

