/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxRetentionPolicy;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

@BoxResourceType(value="retention_policy_assignment")
public class BoxRetentionPolicyAssignment
extends BoxResource {
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_ENTERPRISE = "enterprise";
    public static final URLTemplate ASSIGNMENTS_URL_TEMPLATE = new URLTemplate("retention_policy_assignments");
    public static final URLTemplate RETENTION_POLICY_ASSIGNMENT_URL_TEMPLATE = new URLTemplate("retention_policy_assignments/%s");

    public BoxRetentionPolicyAssignment(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createAssignmentToEnterprise(BoxAPIConnection api, String policyID) {
        return BoxRetentionPolicyAssignment.createAssignment(api, policyID, new JsonObject().add("type", TYPE_ENTERPRISE));
    }

    public static Info createAssignmentToFolder(BoxAPIConnection api, String policyID, String folderID) {
        return BoxRetentionPolicyAssignment.createAssignment(api, policyID, new JsonObject().add("type", TYPE_FOLDER).add("id", folderID));
    }

    private static Info createAssignment(BoxAPIConnection api, String policyID, JsonObject assignTo) {
        BoxRetentionPolicyAssignment createdAssignment;
        URL url = ASSIGNMENTS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("policy_id", policyID).add("assign_to", assignTo);
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxRetentionPolicyAssignment boxRetentionPolicyAssignment = createdAssignment = new BoxRetentionPolicyAssignment(api, responseJSON.get("id").asString());
        boxRetentionPolicyAssignment.getClass();
        return boxRetentionPolicyAssignment.new Info(responseJSON);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = RETENTION_POLICY_ASSIGNMENT_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        return new Info(responseJSON);
    }

    public class Info
    extends BoxResource.Info {
        private BoxRetentionPolicy.Info retentionPolicy;
        private BoxUser.Info assignedBy;
        private Date assignedAt;
        private String assignedToType;
        private String assignedToID;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxRetentionPolicyAssignment.this;
        }

        public BoxRetentionPolicy.Info getRetentionPolicy() {
            return this.retentionPolicy;
        }

        public BoxUser.Info getAssignedBy() {
            return this.assignedBy;
        }

        public Date getAssignedAt() {
            return this.assignedAt;
        }

        public String getAssignedToType() {
            return this.assignedToType;
        }

        public String getAssignedToID() {
            return this.assignedToID;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            block13: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("retention_policy")) {
                        JsonObject policyJSON = value.asObject();
                        if (this.retentionPolicy == null) {
                            BoxRetentionPolicy policy;
                            String policyID = policyJSON.get("id").asString();
                            BoxRetentionPolicy boxRetentionPolicy = policy = new BoxRetentionPolicy(BoxRetentionPolicyAssignment.this.getAPI(), policyID);
                            boxRetentionPolicy.getClass();
                            this.retentionPolicy = boxRetentionPolicy.new BoxRetentionPolicy.Info(policyJSON);
                        } else {
                            this.retentionPolicy.update(policyJSON);
                        }
                    } else if (memberName.equals("assigned_to")) {
                        JsonObject assignmentJSON = value.asObject();
                        this.assignedToType = assignmentJSON.get("type").asString();
                        this.assignedToID = this.assignedToType.equals(BoxRetentionPolicyAssignment.TYPE_FOLDER) ? assignmentJSON.get("id").asString() : null;
                    } else if (memberName.equals("assigned_by")) {
                        JsonObject userJSON = value.asObject();
                        if (this.assignedBy == null) {
                            BoxUser user;
                            String userID = userJSON.get("id").asString();
                            BoxUser boxUser = user = new BoxUser(BoxRetentionPolicyAssignment.this.getAPI(), userID);
                            boxUser.getClass();
                            this.assignedBy = new BoxUser.Info(boxUser, userJSON);
                        } else {
                            this.assignedBy.update(userJSON);
                        }
                    } else if (memberName.equals("assigned_at")) {
                        this.assignedAt = BoxDateFormat.parse(value.asString());
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }
    }
}

