/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxItemIterator;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;

public class BoxTrash
implements Iterable<BoxItem.Info> {
    public static final URLTemplate GET_ITEMS_URL = new URLTemplate("folders/trash/items/");
    public static final URLTemplate FOLDER_INFO_URL_TEMPLATE = new URLTemplate("folders/%s/trash");
    public static final URLTemplate FILE_INFO_URL_TEMPLATE = new URLTemplate("files/%s/trash");
    public static final URLTemplate RESTORE_FILE_URL_TEMPLATE = new URLTemplate("files/%s");
    public static final URLTemplate RESTORE_FOLDER_URL_TEMPLATE = new URLTemplate("folders/%s");
    private static final long LIMIT = 1000L;
    private final BoxAPIConnection api;

    public BoxTrash(BoxAPIConnection api) {
        this.api = api;
    }

    public void deleteFolder(String folderID) {
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.api.getBaseURL(), folderID);
        BoxAPIRequest request = new BoxAPIRequest(this.api, url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public BoxFolder.Info getFolderInfo(String folderID) {
        BoxFolder folder;
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.api.getBaseURL(), folderID);
        BoxAPIRequest request = new BoxAPIRequest(this.api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        BoxFolder boxFolder = folder = new BoxFolder(this.api, jsonObject.get("id").asString());
        boxFolder.getClass();
        return boxFolder.new BoxFolder.Info(response.getJSON());
    }

    public BoxFolder.Info getFolderInfo(String folderID, String ... fields) {
        BoxFolder folder;
        String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
        URL url = FOLDER_INFO_URL_TEMPLATE.buildWithQuery(this.api.getBaseURL(), queryString, folderID);
        BoxAPIRequest request = new BoxAPIRequest(this.api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        BoxFolder boxFolder = folder = new BoxFolder(this.api, jsonObject.get("id").asString());
        boxFolder.getClass();
        return boxFolder.new BoxFolder.Info(response.getJSON());
    }

    public BoxFolder.Info restoreFolder(String folderID) {
        BoxFolder restoredFolder;
        URL url = RESTORE_FOLDER_URL_TEMPLATE.build(this.api.getBaseURL(), folderID);
        BoxAPIRequest request = new BoxAPIRequest(this.api, url, "POST");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxFolder boxFolder = restoredFolder = new BoxFolder(this.api, responseJSON.get("id").asString());
        boxFolder.getClass();
        return boxFolder.new BoxFolder.Info(responseJSON);
    }

    public BoxFolder.Info restoreFolder(String folderID, String newName, String newParentID) {
        BoxFolder restoredFolder;
        JsonObject requestJSON = new JsonObject();
        if (newName != null) {
            requestJSON.add("name", newName);
        }
        if (newParentID != null) {
            JsonObject parent = new JsonObject();
            parent.add("id", newParentID);
            requestJSON.add("parent", parent);
        }
        URL url = RESTORE_FOLDER_URL_TEMPLATE.build(this.api.getBaseURL(), folderID);
        BoxJSONRequest request = new BoxJSONRequest(this.api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxFolder boxFolder = restoredFolder = new BoxFolder(this.api, responseJSON.get("id").asString());
        boxFolder.getClass();
        return boxFolder.new BoxFolder.Info(responseJSON);
    }

    public void deleteFile(String fileID) {
        URL url = FILE_INFO_URL_TEMPLATE.build(this.api.getBaseURL(), fileID);
        BoxAPIRequest request = new BoxAPIRequest(this.api, url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public BoxFile.Info getFileInfo(String fileID) {
        BoxFile file;
        URL url = FILE_INFO_URL_TEMPLATE.build(this.api.getBaseURL(), fileID);
        BoxAPIRequest request = new BoxAPIRequest(this.api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        BoxFile boxFile = file = new BoxFile(this.api, jsonObject.get("id").asString());
        boxFile.getClass();
        return boxFile.new BoxFile.Info(response.getJSON());
    }

    public BoxFile.Info getFileInfo(String fileID, String ... fields) {
        BoxFile file;
        String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
        URL url = FILE_INFO_URL_TEMPLATE.buildWithQuery(this.api.getBaseURL(), queryString, fileID);
        BoxAPIRequest request = new BoxAPIRequest(this.api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        BoxFile boxFile = file = new BoxFile(this.api, jsonObject.get("id").asString());
        boxFile.getClass();
        return boxFile.new BoxFile.Info(response.getJSON());
    }

    public BoxFile.Info restoreFile(String fileID) {
        BoxFile restoredFile;
        URL url = RESTORE_FILE_URL_TEMPLATE.build(this.api.getBaseURL(), fileID);
        BoxAPIRequest request = new BoxAPIRequest(this.api, url, "POST");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxFile boxFile = restoredFile = new BoxFile(this.api, responseJSON.get("id").asString());
        boxFile.getClass();
        return boxFile.new BoxFile.Info(responseJSON);
    }

    public BoxFile.Info restoreFile(String fileID, String newName, String newParentID) {
        BoxFile restoredFile;
        JsonObject requestJSON = new JsonObject();
        if (newName != null) {
            requestJSON.add("name", newName);
        }
        if (newParentID != null) {
            JsonObject parent = new JsonObject();
            parent.add("id", newParentID);
            requestJSON.add("parent", parent);
        }
        URL url = RESTORE_FILE_URL_TEMPLATE.build(this.api.getBaseURL(), fileID);
        BoxJSONRequest request = new BoxJSONRequest(this.api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxFile boxFile = restoredFile = new BoxFile(this.api, responseJSON.get("id").asString());
        boxFile.getClass();
        return boxFile.new BoxFile.Info(responseJSON);
    }

    @Override
    public Iterator<BoxItem.Info> iterator() {
        URL url = GET_ITEMS_URL.build(this.api.getBaseURL(), new Object[0]);
        return new BoxItemIterator(this.api, url);
    }
}

