/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.Base64;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileUploadSession;
import com.box.sdk.BoxFileUploadSessionPart;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.LargeFileUploadTask;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class LargeFileUpload {
    private static final String DIGEST_HEADER_PREFIX_SHA = "sha=";
    private static final String DIGEST_ALGORITHM_SHA1 = "SHA1";
    private static final String OFFSET_QUERY_STRING = "offset";
    private static final String LIMIT_QUERY_STRING = "limit";
    private static final int DEFAULT_CONNECTIONS = 3;
    private static final int DEFAULT_TIMEOUT = 1;
    private static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.HOURS;
    private static final int THREAD_POOL_WAIT_TIME_IN_MILLIS = 1000;
    private ThreadPoolExecutor executorService;
    private long timeout;
    private TimeUnit timeUnit;
    private int connections;

    public LargeFileUpload(int nParallelConnections, long timeOut, TimeUnit unit) {
        this.executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(nParallelConnections);
        this.timeout = timeOut;
        this.timeUnit = unit;
    }

    public LargeFileUpload() {
        this.executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(3);
        this.timeout = 1L;
        this.timeUnit = DEFAULT_TIMEUNIT;
    }

    private BoxFileUploadSession.Info createUploadSession(BoxAPIConnection boxApi, String folderId, URL url, String fileName, long fileSize) {
        BoxFileUploadSession session;
        BoxJSONRequest request = new BoxJSONRequest(boxApi, url, HttpMethod.POST);
        JsonObject body = new JsonObject();
        body.add("folder_id", folderId);
        body.add("file_name", fileName);
        body.add("file_size", fileSize);
        request.setBody(body.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        String sessionId = jsonObject.get("id").asString();
        BoxFileUploadSession boxFileUploadSession = session = new BoxFileUploadSession(boxApi, sessionId);
        boxFileUploadSession.getClass();
        return boxFileUploadSession.new BoxFileUploadSession.Info(jsonObject);
    }

    public BoxFile.Info upload(BoxAPIConnection boxApi, String folderId, InputStream stream, URL url, String fileName, long fileSize) throws InterruptedException, IOException {
        BoxFileUploadSession.Info session = this.createUploadSession(boxApi, folderId, url, fileName, fileSize);
        return this.uploadHelper(session, stream, fileSize);
    }

    public BoxFile.Info upload(BoxAPIConnection boxApi, InputStream stream, URL url, long fileSize) throws InterruptedException, IOException {
        BoxFileUploadSession.Info session = this.createUploadSession(boxApi, url, fileSize);
        return this.uploadHelper(session, stream, fileSize);
    }

    private BoxFile.Info uploadHelper(BoxFileUploadSession.Info session, InputStream stream, long fileSize) throws InterruptedException, IOException {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(DIGEST_ALGORITHM_SHA1);
        }
        catch (NoSuchAlgorithmException ae) {
            throw new BoxAPIException("Digest algorithm not found", ae);
        }
        DigestInputStream dis = new DigestInputStream(stream, digest);
        List<BoxFileUploadSessionPart> parts = this.uploadParts(session, dis, fileSize);
        byte[] digestBytes = digest.digest();
        String digestStr = Base64.encode(digestBytes);
        try {
            return session.getResource().commit(digestStr, parts, null, null, null);
        }
        catch (Exception e) {
            session.getResource().abort();
            throw new BoxAPIException("Unable to commit the upload session", e);
        }
    }

    private BoxFileUploadSession.Info createUploadSession(BoxAPIConnection boxApi, URL url, long fileSize) {
        BoxFileUploadSession session;
        BoxJSONRequest request = new BoxJSONRequest(boxApi, url, HttpMethod.POST);
        JsonObject body = new JsonObject();
        body.add("file_size", fileSize);
        request.setBody(body.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        String sessionId = jsonObject.get("id").asString();
        BoxFileUploadSession boxFileUploadSession = session = new BoxFileUploadSession(boxApi, sessionId);
        boxFileUploadSession.getClass();
        return boxFileUploadSession.new BoxFileUploadSession.Info(jsonObject);
    }

    private List<BoxFileUploadSessionPart> uploadParts(BoxFileUploadSession.Info session, InputStream stream, long fileSize) throws InterruptedException {
        ArrayList<BoxFileUploadSessionPart> parts = new ArrayList<BoxFileUploadSessionPart>();
        int partSize = session.getPartSize();
        long offset = 0L;
        int processed = 0;
        int partPostion = 0;
        while ((long)processed < fileSize) {
            long diff;
            long timeoutForWaitingInMillis = TimeUnit.MILLISECONDS.convert(this.timeout, this.timeUnit);
            if (this.executorService.getCorePoolSize() <= this.executorService.getActiveCount()) {
                if (timeoutForWaitingInMillis > 0L) {
                    Thread.sleep(1000L);
                    timeoutForWaitingInMillis -= 1000L;
                } else {
                    throw new BoxAPIException("Upload parts timedout");
                }
            }
            if ((diff = fileSize - (long)processed) < (long)partSize) {
                partSize = (int)diff;
            }
            parts.add(null);
            byte[] bytes = new byte[partSize];
            try {
                int readStatus = stream.read(bytes);
                if (readStatus == -1) {
                    throw new BoxAPIException("Stream ended while upload was progressing");
                }
            }
            catch (IOException ioe) {
                throw new BoxAPIException("Reading data from stream failed.", ioe);
            }
            this.executorService.execute(new LargeFileUploadTask(session.getResource(), bytes, offset, partSize, fileSize, parts, partPostion));
            processed += partSize;
            offset += (long)partSize;
            ++partPostion;
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(this.timeout, this.timeUnit);
        return parts;
    }

    public String generateDigest(InputStream stream) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(DIGEST_ALGORITHM_SHA1);
        }
        catch (NoSuchAlgorithmException ae) {
            throw new BoxAPIException("Digest algorithm not found", ae);
        }
        DigestInputStream dis = new DigestInputStream(stream, digest);
        try {
            int value = dis.read();
            while (value != -1) {
                value = dis.read();
            }
        }
        catch (IOException ioe) {
            throw new BoxAPIException("Reading the stream failed.", ioe);
        }
        byte[] digestBytes = digest.digest();
        return Base64.encode(digestBytes);
    }
}

