/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.w3c.dom.ranges.Range;

public abstract class InteractivePage
extends SgmlPage {
    private DomElement elementWithFocus_;
    private List<Range> selectionRanges_ = new ArrayList<Range>(3);

    public InteractivePage(WebResponse webResponse, WebWindow webWindow) {
        super(webResponse, webWindow);
    }

    public boolean setFocusedElement(DomElement newElement) {
        return this.setFocusedElement(newElement, false);
    }

    public boolean setFocusedElement(DomElement newElement, boolean windowActivated) {
        if (this.elementWithFocus_ == newElement && !windowActivated) {
            return true;
        }
        DomElement oldFocusedElement = this.elementWithFocus_;
        this.elementWithFocus_ = null;
        if (!windowActivated) {
            if (this.hasFeature(BrowserVersionFeatures.EVENT_FOCUS_IN_FOCUS_OUT_BLUR)) {
                if (oldFocusedElement != null) {
                    oldFocusedElement.fireEvent("focusout");
                }
                if (newElement != null) {
                    newElement.fireEvent("focusin");
                }
            }
            if (oldFocusedElement != null) {
                oldFocusedElement.removeFocus();
                oldFocusedElement.fireEvent("blur");
            }
        }
        this.elementWithFocus_ = newElement;
        if (this.elementWithFocus_ instanceof SelectableTextInput && this.hasFeature(BrowserVersionFeatures.PAGE_SELECTION_RANGE_FROM_SELECTABLE_TEXT_INPUT)) {
            SelectableTextInput sti = (SelectableTextInput)((Object)this.elementWithFocus_);
            this.setSelectionRange(new SimpleRange(sti, sti.getSelectionStart(), sti, sti.getSelectionEnd()));
        }
        if (this.elementWithFocus_ != null) {
            this.elementWithFocus_.focus();
            this.elementWithFocus_.fireEvent("focus");
        }
        if (this.hasFeature(BrowserVersionFeatures.EVENT_FOCUS_FOCUS_IN_BLUR_OUT)) {
            if (oldFocusedElement != null) {
                oldFocusedElement.fireEvent("focusout");
            }
            if (newElement != null) {
                newElement.fireEvent("focusin");
            }
        }
        return this == this.getEnclosingWindow().getEnclosedPage();
    }

    public DomElement getFocusedElement() {
        return this.elementWithFocus_;
    }

    public void setElementWithFocus(DomElement elementWithFocus) {
        this.elementWithFocus_ = elementWithFocus;
    }

    public List<Range> getSelectionRanges() {
        return this.selectionRanges_;
    }

    public void setSelectionRange(Range selectionRange) {
        this.selectionRanges_.clear();
        this.selectionRanges_.add(selectionRange);
    }

    @Override
    public InteractivePage cloneNode(boolean deep) {
        InteractivePage result = (InteractivePage)super.cloneNode(false);
        SimpleScriptable jsObjClone = ((SimpleScriptable)this.getScriptableObject()).clone();
        jsObjClone.setDomNode(result);
        if (deep) {
            result.selectionRanges_ = new ArrayList<Range>(3);
        }
        return result;
    }

    public ScriptResult executeJavaScriptFunctionIfPossible(Function function, Scriptable thisObject, Object[] args, DomNode htmlElementScope) {
        if (!this.getWebClient().getOptions().isJavaScriptEnabled()) {
            return new ScriptResult(null, this);
        }
        JavaScriptEngine engine = this.getWebClient().getJavaScriptEngine();
        Object result = engine.callFunction(this, function, thisObject, args, htmlElementScope);
        return new ScriptResult(result, this.getWebClient().getCurrentWindow().getEnclosedPage());
    }

    @Override
    protected InteractivePage clone() {
        InteractivePage result = (InteractivePage)super.clone();
        result.elementWithFocus_ = null;
        return result;
    }
}

