/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxEvent;
import com.box.sdk.EventLog;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxEventLogsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxEventLogsManager.class);
    private BoxAPIConnection boxConnection;

    public BoxEventLogsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public List<BoxEvent> getEnterpriseEvents(String position, Date after, Date before, BoxEvent.Type ... types) {
        try {
            LOG.debug("Getting all enterprise events occuring between " + (after == null ? after : SimpleDateFormat.getDateTimeInstance().format(after)) + " and " + (before == null ? before : SimpleDateFormat.getDateTimeInstance().format(before)) + (position == null ? position : " starting at " + position));
            if (after == null) {
                throw new IllegalArgumentException("Parameter 'after' can not be null");
            }
            if (before == null) {
                throw new IllegalArgumentException("Parameter 'before' can not be null");
            }
            if (types == null) {
                types = new BoxEvent.Type[]{};
            }
            EventLog eventLog = EventLog.getEnterpriseEvents(this.boxConnection, position, after, before, types);
            ArrayList<BoxEvent> results = new ArrayList<BoxEvent>();
            for (BoxEvent event : eventLog) {
                results.add(event);
            }
            return results;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

