/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxSearchManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxSearchManager.class);
    private BoxAPIConnection boxConnection;

    public BoxSearchManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public Collection<BoxItem> searchFolder(String folderId, String query) {
        try {
            LOG.debug("Searching folder(id=" + folderId + ") with query=" + query);
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (query == null) {
                throw new IllegalArgumentException("Parameter 'query' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            ArrayList<BoxItem> results = new ArrayList<BoxItem>();
            for (BoxItem.Info info : folder.search(query)) {
                results.add((BoxItem)info.getResource());
            }
            return results;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

