/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

@BoxResourceType(value="collaboration")
public class BoxCollaboration
extends BoxResource {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "item", "accessible_by", "role", "expires_at", "can_view_path", "status", "acknowledged_at", "created_by", "created_at", "modified_at"};
    public static final URLTemplate COLLABORATIONS_URL_TEMPLATE = new URLTemplate("collaborations");
    public static final URLTemplate PENDING_COLLABORATIONS_URL = new URLTemplate("collaborations?status=pending");
    public static final URLTemplate COLLABORATION_URL_TEMPLATE = new URLTemplate("collaborations/%s");
    public static final URLTemplate GET_ALL_FILE_COLLABORATIONS_URL = new URLTemplate("files/%s/collaborations");

    public BoxCollaboration(BoxAPIConnection api, String id) {
        super(api, id);
    }

    protected static Info create(BoxAPIConnection api, JsonObject accessibleBy, JsonObject item, Role role, Boolean notify, Boolean canViewPath) {
        return BoxCollaboration.create(api, accessibleBy, item, role, notify, canViewPath, null);
    }

    protected static Info create(BoxAPIConnection api, JsonObject accessibleBy, JsonObject item, Role role, Boolean notify, Boolean canViewPath, Date expiresAt) {
        BoxCollaboration newCollaboration;
        String queryString = "";
        if (notify != null) {
            queryString = new QueryStringBuilder().appendParam("notify", notify.toString()).toString();
        }
        URL url = queryString.length() > 0 ? COLLABORATIONS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), queryString, new Object[0]) : COLLABORATIONS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("item", item);
        requestJSON.add("accessible_by", accessibleBy);
        requestJSON.add("role", role.toJSONString());
        if (canViewPath != null) {
            requestJSON.add("can_view_path", canViewPath);
        }
        if (expiresAt != null) {
            requestJSON.add("expires_at", BoxDateFormat.format(expiresAt));
        }
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxCollaboration boxCollaboration = newCollaboration = new BoxCollaboration(api, responseJSON.get("id").asString());
        boxCollaboration.getClass();
        return boxCollaboration.new Info(responseJSON);
    }

    public static Collection<Info> getPendingCollaborations(BoxAPIConnection api) {
        URL url = PENDING_COLLABORATIONS_URL.build(api.getBaseURL(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<Info> collaborations = new ArrayList<Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxCollaboration collaboration;
            JsonObject entryObject = entry.asObject();
            BoxCollaboration boxCollaboration = collaboration = new BoxCollaboration(api, entryObject.get("id").asString());
            boxCollaboration.getClass();
            Info info = boxCollaboration.new Info(entryObject);
            collaborations.add(info);
        }
        return collaborations;
    }

    public static BoxResourceIterable<Info> getAllFileCollaborations(final BoxAPIConnection api, String fileID, int pageSize, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<Info>(api, GET_ALL_FILE_COLLABORATIONS_URL.buildWithQuery(api.getBaseURL(), builder.toString(), fileID), pageSize){

            @Override
            protected Info factory(JsonObject jsonObject) {
                String id = jsonObject.get("id").asString();
                BoxCollaboration boxCollaboration = new BoxCollaboration(api, id);
                boxCollaboration.getClass();
                return boxCollaboration.new Info(jsonObject);
            }
        };
    }

    public Info getInfo() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        return new Info(jsonObject);
    }

    public Info getInfo(String ... fields) {
        String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
        URL url = COLLABORATION_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    public void updateInfo(Info info) {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(api, url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxAPIResponse boxAPIResponse = request.send();
        if (boxAPIResponse instanceof BoxJSONResponse) {
            BoxJSONResponse response = (BoxJSONResponse)boxAPIResponse;
            JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
            info.update(jsonObject);
        }
    }

    public void delete() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxResource.Info {
        private BoxUser.Info createdBy;
        private Date createdAt;
        private Date modifiedAt;
        private Date expiresAt;
        private Status status;
        private BoxCollaborator.Info accessibleBy;
        private Role role;
        private Date acknowledgedAt;
        private BoxFolder.Info item;
        private BoxFile.Info fileItem;
        private String inviteEmail;
        private boolean canViewPath;

        public Info() {
            super(BoxCollaboration.this);
        }

        public Info(String json) {
            super((BoxResource)BoxCollaboration.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxCollaboration.this, jsonObject);
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(Date expiresAt) {
            this.expiresAt = expiresAt;
            this.addPendingChange("expires_at", BoxDateFormat.format(expiresAt));
        }

        public boolean getCanViewPath() {
            return this.canViewPath;
        }

        public void setCanViewPath(boolean canViewState) {
            this.canViewPath = canViewState;
            this.addPendingChange("can_view_path", canViewState);
        }

        public String getInviteEmail() {
            return this.inviteEmail;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
            this.addPendingChange("status", status.name().toLowerCase());
        }

        public BoxCollaborator.Info getAccessibleBy() {
            return this.accessibleBy;
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
            this.addPendingChange("role", role.toJSONString());
        }

        public Date getAcknowledgedAt() {
            return this.acknowledgedAt;
        }

        public BoxFolder.Info getItem() {
            return this.item;
        }

        @Override
        public BoxCollaboration getResource() {
            return BoxCollaboration.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("created_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.createdBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxCollaboration.this.getAPI(), userID);
                        boxUser.getClass();
                        this.createdBy = new BoxUser.Info(boxUser, userJSON);
                    } else {
                        this.createdBy.update(userJSON);
                    }
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("expires_at")) {
                    this.expiresAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("status")) {
                    String statusString = value.asString().toUpperCase();
                    this.status = Status.valueOf(statusString);
                } else if (memberName.equals("accessible_by")) {
                    JsonObject accessibleByJSON = value.asObject();
                    if (this.accessibleBy == null) {
                        this.accessibleBy = this.parseAccessibleBy(accessibleByJSON);
                    } else {
                        this.updateAccessibleBy(accessibleByJSON);
                    }
                } else if (memberName.equals("role")) {
                    this.role = Role.fromJSONString(value.asString());
                } else if (memberName.equals("acknowledged_at")) {
                    this.acknowledgedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("can_view_path")) {
                    this.canViewPath = value.asBoolean();
                } else if (memberName.equals("invite_email")) {
                    this.inviteEmail = value.asString();
                } else if (memberName.equals("item")) {
                    JsonObject folderJSON = value.asObject();
                    if (this.item == null) {
                        BoxFolder folder;
                        String folderID = folderJSON.get("id").asString();
                        BoxFolder boxFolder = folder = new BoxFolder(BoxCollaboration.this.getAPI(), folderID);
                        boxFolder.getClass();
                        this.item = new BoxFolder.Info(boxFolder, folderJSON);
                    } else {
                        this.item.update(folderJSON);
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private void updateAccessibleBy(JsonObject json) {
            String type = json.get("type").asString();
            if (type.equals("user") && this.accessibleBy instanceof BoxUser.Info || type.equals("group") && this.accessibleBy instanceof BoxGroup.Info) {
                this.accessibleBy.update(json);
            } else {
                this.accessibleBy = this.parseAccessibleBy(json);
            }
        }

        private BoxCollaborator.Info parseAccessibleBy(JsonObject json) {
            String id = json.get("id").asString();
            String type = json.get("type").asString();
            BoxCollaborator.Info parsedInfo = null;
            if (type.equals("user")) {
                BoxUser user;
                BoxUser boxUser = user = new BoxUser(BoxCollaboration.this.getAPI(), id);
                boxUser.getClass();
                parsedInfo = new BoxUser.Info(boxUser, json);
            } else if (type.equals("group")) {
                BoxGroup group;
                BoxGroup boxGroup = group = new BoxGroup(BoxCollaboration.this.getAPI(), id);
                boxGroup.getClass();
                parsedInfo = new BoxGroup.Info(boxGroup, json);
            }
            return parsedInfo;
        }
    }

    public static enum Role {
        EDITOR("editor"),
        VIEWER("viewer"),
        PREVIEWER("previewer"),
        UPLOADER("uploader"),
        PREVIEWER_UPLOADER("previewer uploader"),
        VIEWER_UPLOADER("viewer uploader"),
        CO_OWNER("co-owner"),
        OWNER("owner");

        private final String jsonValue;

        private Role(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Role fromJSONString(String jsonValue) {
            if (jsonValue.equals("editor")) {
                return EDITOR;
            }
            if (jsonValue.equals("viewer")) {
                return VIEWER;
            }
            if (jsonValue.equals("previewer")) {
                return PREVIEWER;
            }
            if (jsonValue.equals("uploader")) {
                return UPLOADER;
            }
            if (jsonValue.equals("previewer uploader")) {
                return PREVIEWER_UPLOADER;
            }
            if (jsonValue.equals("viewer uploader")) {
                return VIEWER_UPLOADER;
            }
            if (jsonValue.equals("co-owner")) {
                return CO_OWNER;
            }
            if (jsonValue.equals("owner")) {
                return OWNER;
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid Role.");
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }

    public static enum Status {
        ACCEPTED,
        PENDING,
        REJECTED;

    }
}

