/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

@BoxResourceType(value="device_pin")
public class BoxDevicePin
extends BoxResource {
    public static final URLTemplate DEVICE_PIN_URL_TEMPLATE = new URLTemplate("device_pinners/%s");
    public static final URLTemplate ENTERPRISE_DEVICE_PINS_TEMPLATE = new URLTemplate("enterprises/%s/device_pinners");
    private static final int DEVICES_DEFAULT_LIMIT = 100;

    public BoxDevicePin(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Iterable<Info> getEnterpriceDevicePins(BoxAPIConnection api, String enterpriseID, String ... fields) {
        return BoxDevicePin.getEnterpriceDevicePins(api, enterpriseID, 100, fields);
    }

    public static Iterable<Info> getEnterpriceDevicePins(final BoxAPIConnection api, String enterpriseID, int limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<Info>(api, ENTERPRISE_DEVICE_PINS_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), enterpriseID), limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxDevicePin pin;
                BoxDevicePin boxDevicePin = pin = new BoxDevicePin(api, jsonObject.get("id").asString());
                boxDevicePin.getClass();
                return boxDevicePin.new Info(jsonObject);
            }
        };
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = DEVICE_PIN_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        return new Info(responseJSON);
    }

    public void delete() {
        URL url = DEVICE_PIN_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxResource.Info {
        private BoxUser.Info ownedBy;
        private String productName;
        private Date createdAt;
        private Date modifiedAt;

        public Info() {
            super(BoxDevicePin.this);
        }

        public Info(String json) {
            super((BoxResource)BoxDevicePin.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxDevicePin.this, jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxDevicePin.this;
        }

        public BoxUser.Info getOwnedBy() {
            return this.ownedBy;
        }

        public String getProductName() {
            return this.productName;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            block11: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("owned_by")) {
                        JsonObject userJSON = value.asObject();
                        if (this.ownedBy == null) {
                            BoxUser user;
                            String userID = userJSON.get("id").asString();
                            BoxUser boxUser = user = new BoxUser(BoxDevicePin.this.getAPI(), userID);
                            boxUser.getClass();
                            this.ownedBy = new BoxUser.Info(boxUser, userJSON);
                        } else {
                            this.ownedBy.update(userJSON);
                        }
                    } else if (memberName.equals("product_name")) {
                        this.productName = value.asString();
                    } else if (memberName.equals("created_at")) {
                        this.createdAt = BoxDateFormat.parse(value.asString());
                    } else if (memberName.equals("modified_at")) {
                        this.modifiedAt = BoxDateFormat.parse(value.asString());
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }
    }
}

